/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.contouring;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;

public class SnyderContour {
    static final boolean SHOW_NUMBERS = true;
    static final int BLANK = 32;
    static final int OPEN_SUITE = 123;
    static final int CLOSE_SUITE = 125;
    static final int BETWEEN_ARGS = 44;
    static final int N_CONTOURS = 1;
    static final int PLOT_MARGIN = 20;
    static final int WEE_BIT = 3;
    static final int NUMBER_LENGTH = 3;
    static final double Z_MAX_MAX = 1.0E10;
    static final double Z_MIN_MIN = -1.0E10;
    static final String EOL = System.getProperty("line.separator");
    int xSteps;
    int ySteps;
    float[][] z;
    boolean logInterpolation = false;
    Dimension d;
    double deltaX;
    double deltaY;
    int ncv = 1;
    int[] l1 = new int[4];
    int[] l2 = new int[4];
    int[] ij = new int[2];
    int[] i1 = new int[2];
    int[] i2 = new int[2];
    int[] i3 = new int[6];
    int ibkey;
    int icur;
    int jcur;
    int ii;
    int jj;
    int elle;
    int ix;
    int iedge;
    int iflag;
    int ni;
    int ks;
    int cntrIndex;
    int prevIndex;
    int idir;
    int nxidir;
    int k;
    double z1;
    double z2;
    double cval;
    double zMax;
    double zMin;
    double[] intersect = new double[4];
    double[] xy = new double[2];
    double[] prevXY = new double[2];
    float[] cv = new float[this.ncv];
    boolean jump;
    double offsetX;
    double offsetY;

    public SnyderContour(int n, int n2) {
        this.xSteps = n;
        this.ySteps = n2;
    }

    public void setDeltas(double d, double d2) {
        this.deltaX = d;
        this.deltaY = d2;
    }

    public void setOffsets(double d, double d2) {
        this.offsetX = d;
        this.offsetY = d2;
    }

    int sign(int n, int n2) {
        n = Math.abs(n);
        if (n2 < 0) {
            return -n;
        }
        return n;
    }

    void DrawKernel(List<LinkedList<Point2D>> list) {
        LinkedList<Point2D> linkedList;
        double d;
        double d2;
        if (this.iflag == 1 || this.iflag == 4 || this.iflag == 5) {
            if (this.cntrIndex != this.prevIndex) {
                this.prevIndex = this.cntrIndex;
            }
            d2 = (this.xy[0] - 1.0) * this.deltaX + this.offsetX;
            d = (this.xy[1] - 1.0) * this.deltaY + this.offsetY;
            linkedList = list.get(list.size() - 1);
            linkedList.add(new Point2D.Double(d2, d));
        }
        if (this.iflag == 2 || this.iflag == 3) {
            d2 = (this.xy[0] - 1.0) * this.deltaX + this.offsetX;
            d = (this.xy[1] - 1.0) * this.deltaY + this.offsetY;
            linkedList = new LinkedList();
            linkedList.add(new Point2D.Double(d2, d));
            list.add(linkedList);
        }
        this.prevXY[0] = this.xy[0];
        this.prevXY[1] = this.xy[1];
    }

    void DetectBoundary() {
        this.ix = 1;
        if (this.ij[1 - this.elle] != 1) {
            this.ii = this.ij[0] - this.i1[1 - this.elle];
            this.jj = this.ij[1] - this.i1[this.elle];
            if ((double)this.z[this.ii - 1][this.jj - 1] <= 1.0E10) {
                this.ii = this.ij[0] + this.i2[this.elle];
                this.jj = this.ij[1] + this.i2[1 - this.elle];
                if ((double)this.z[this.ii - 1][this.jj - 1] < 1.0E10) {
                    this.ix = 0;
                }
            }
            if (this.ij[1 - this.elle] >= this.l1[1 - this.elle]) {
                this.ix += 2;
                return;
            }
        }
        this.ii = this.ij[0] + this.i1[1 - this.elle];
        this.jj = this.ij[1] + this.i1[this.elle];
        if ((double)this.z[this.ii - 1][this.jj - 1] > 1.0E10) {
            this.ix += 2;
            return;
        }
        if ((double)this.z[this.ij[0]][this.ij[1]] >= 1.0E10) {
            this.ix += 2;
        }
    }

    boolean Routine_label_020() {
        this.l2[0] = this.ij[0];
        this.l2[1] = this.ij[1];
        this.l2[2] = -this.ij[0];
        this.l2[3] = -this.ij[1];
        this.idir = 0;
        this.nxidir = 1;
        this.k = 1;
        this.ij[0] = Math.abs(this.ij[0]);
        this.ij[1] = Math.abs(this.ij[1]);
        if ((double)this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
            this.elle = this.idir % 2;
            this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
            return true;
        }
        this.elle = 0;
        return false;
    }

    boolean Routine_label_050() {
        block2: {
            while (true) {
                if (this.ij[this.elle] >= this.l1[this.elle]) {
                    if (++this.elle <= 1) continue;
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    if (!this.Routine_label_150()) continue;
                    return true;
                }
                this.ii = this.ij[0] + this.i1[this.elle];
                this.jj = this.ij[1] + this.i1[1 - this.elle];
                if (!((double)this.z[this.ii - 1][this.jj - 1] > 1.0E10)) break block2;
                if (++this.elle <= 1) continue;
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.Routine_label_150()) break;
            }
            return true;
        }
        this.jump = false;
        return false;
    }

    boolean Routine_label_150() {
        while (true) {
            if (this.ij[this.elle] < this.l1[this.k - 1]) {
                int n = this.elle;
                this.ij[n] = this.ij[n] + 1;
                if (this.ij[this.elle] > this.l2[this.k - 1]) {
                    this.l2[this.k - 1] = this.ij[this.elle];
                    this.idir = this.nxidir;
                    this.k = this.nxidir = this.idir + 1;
                    if (this.nxidir > 3) {
                        this.nxidir = 0;
                    }
                }
                this.ij[0] = Math.abs(this.ij[0]);
                this.ij[1] = Math.abs(this.ij[1]);
                if ((double)this.z[this.ij[0] - 1][this.ij[1] - 1] > 1.0E10) {
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    continue;
                }
                this.elle = 0;
                return false;
            }
            if (this.idir != this.nxidir) {
                this.ij[this.elle] = this.l1[this.k - 1];
                this.k = ++this.nxidir;
                this.elle = 1 - this.elle;
                this.ij[this.elle] = this.l2[this.k - 1];
                if (this.nxidir <= 3) continue;
                this.nxidir = 0;
                continue;
            }
            if (this.ibkey != 0) {
                return true;
            }
            this.ibkey = 1;
            this.ij[0] = this.icur;
            this.ij[1] = this.jcur;
            if (!this.Routine_label_020()) break;
        }
        return false;
    }

    short Routine_label_200(List<LinkedList<Point2D>> list, boolean[] blArray) {
        while (true) {
            this.xy[this.elle] = 1.0 * (double)this.ij[this.elle] + this.intersect[this.iedge - 1];
            this.xy[1 - this.elle] = 1.0 * (double)this.ij[1 - this.elle];
            blArray[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle] = true;
            this.DrawKernel(list);
            if (this.iflag >= 4) {
                this.icur = this.ij[0];
                this.jcur = this.ij[1];
                return 1;
            }
            this.ContinueContour();
            if (!blArray[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle]) {
                return 2;
            }
            this.iflag = 5;
            this.iedge = this.ks + 2;
            if (this.iedge > 4) {
                this.iedge -= 4;
            }
            this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
        }
    }

    boolean CrossedByContour(boolean[] blArray) {
        this.ii = this.ij[0] + this.i1[this.elle];
        this.jj = this.ij[1] + this.i1[1 - this.elle];
        this.z1 = this.z[this.ij[0] - 1][this.ij[1] - 1];
        this.z2 = this.z[this.ii - 1][this.jj - 1];
        this.cntrIndex = 0;
        while (this.cntrIndex < this.ncv) {
            float f;
            int n = 2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle;
            if (!blArray[n] && (double)(f = this.cv[this.cntrIndex]) > Math.min(this.z1, this.z2) && (double)f <= Math.max(this.z1, this.z2)) {
                blArray[n] = true;
                return true;
            }
            ++this.cntrIndex;
        }
        return false;
    }

    void ContinueContour() {
        this.ni = 1;
        if (this.iedge >= 3) {
            this.ij[0] = this.ij[0] - this.i3[this.iedge - 1];
            this.ij[1] = this.ij[1] - this.i3[this.iedge + 1];
        }
        for (int n = 1; n < 5; n = (int)((short)(n + 1))) {
            if (n == this.iedge) continue;
            this.ii = this.ij[0] + this.i3[n - 1];
            this.jj = this.ij[1] + this.i3[n];
            this.z1 = this.z[this.ii - 1][this.jj - 1];
            this.ii = this.ij[0] + this.i3[n];
            this.jj = this.ij[1] + this.i3[n + 1];
            this.z2 = this.z[this.ii - 1][this.jj - 1];
            if (!(this.cval > Math.min(this.z1, this.z2)) || !(this.cval <= Math.max(this.z1, this.z2))) continue;
            if (n == 1 || n == 4) {
                double d = this.z2;
                this.z2 = this.z1;
                this.z1 = d;
            }
            this.intersect[n - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
            ++this.ni;
            this.ks = n;
        }
        if (this.ni != 2) {
            this.ks = 5 - this.iedge;
            if (this.intersect[2] >= this.intersect[0]) {
                this.ks = 3 - this.iedge;
                if (this.ks <= 0) {
                    this.ks += 4;
                }
            }
        }
        this.elle = this.ks - 1;
        this.iflag = 1;
        this.jump = true;
        if (this.ks >= 3) {
            this.ij[0] = this.ij[0] + this.i3[this.ks - 1];
            this.ij[1] = this.ij[1] + this.i3[this.ks + 1];
            this.elle = this.ks - 3;
        }
    }

    void ContourKernel(double[][] dArray, List<LinkedList<Point2D>> list, double d) {
        this.ncv = 1;
        this.cv[0] = (float)d;
        int n = 2 * this.xSteps * this.ySteps * this.ncv;
        this.z = new float[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                this.z[i][j] = (float)dArray[i][j];
            }
        }
        boolean[] blArray = new boolean[n];
        this.ContourPlotKernel(list, blArray);
    }

    void ContourPlotKernel(List<LinkedList<Point2D>> list, boolean[] blArray) {
        this.l1[0] = this.xSteps;
        this.l1[1] = this.ySteps;
        this.l1[2] = -1;
        this.l1[3] = -1;
        this.i1[0] = 1;
        this.i1[1] = 0;
        this.i2[0] = 1;
        this.i2[1] = -1;
        this.i3[0] = 1;
        this.i3[1] = 0;
        this.i3[2] = 0;
        this.i3[3] = 1;
        this.i3[4] = 1;
        this.i3[5] = 0;
        this.prevXY[0] = 0.0;
        this.prevXY[1] = 0.0;
        this.xy[0] = 1.0;
        this.xy[1] = 1.0;
        this.cntrIndex = 0;
        this.prevIndex = -1;
        this.iflag = 6;
        this.icur = Math.max(1, Math.min((int)Math.floor(this.xy[0]), this.xSteps));
        this.jcur = Math.max(1, Math.min((int)Math.floor(this.xy[1]), this.ySteps));
        this.ibkey = 0;
        this.ij[0] = this.icur;
        this.ij[1] = this.jcur;
        if (this.Routine_label_020() && this.Routine_label_150()) {
            return;
        }
        if (this.Routine_label_050()) {
            return;
        }
        while (true) {
            short s;
            this.DetectBoundary();
            if (this.jump) {
                if (this.ix != 0) {
                    this.iflag = 4;
                }
                this.iedge = this.ks + 2;
                if (this.iedge > 4) {
                    this.iedge -= 4;
                }
                this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
                s = this.Routine_label_200(list, blArray);
                if (s == 1) {
                    if (this.Routine_label_020() && this.Routine_label_150()) {
                        return;
                    }
                    if (!this.Routine_label_050()) continue;
                    return;
                }
                if (s == 2) continue;
                return;
            }
            if (this.ix != 3 && this.ix + this.ibkey != 0 && this.CrossedByContour(blArray)) {
                this.iedge = this.elle + 1;
                this.cval = this.cv[this.cntrIndex];
                if (this.ix != 1) {
                    this.iedge += 2;
                }
                this.iflag = 2 + this.ibkey;
                this.intersect[this.iedge - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
                s = this.Routine_label_200(list, blArray);
                if (s == 1) {
                    if (this.Routine_label_020() && this.Routine_label_150()) {
                        return;
                    }
                    if (!this.Routine_label_050()) continue;
                    return;
                }
                if (s == 2) continue;
                return;
            }
            if (++this.elle > 1) {
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                if (this.Routine_label_150()) {
                    return;
                }
            }
            if (this.Routine_label_050()) break;
        }
    }
}

