/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.util.Attributable;
import java.util.Iterator;

public class SimpleNode
implements NodeRef,
Attributable {
    private SimpleNode parent = null;
    private int nodeNumber;
    private double height;
    private double rate;
    private Taxon taxon = null;
    private SimpleNode[] child;
    private String id = null;
    private Attributable.AttributeHelper attributes = null;

    public SimpleNode() {
        this.child = null;
        this.height = 0.0;
        this.rate = 1.0;
        this.nodeNumber = 0;
    }

    public SimpleNode(SimpleNode simpleNode) {
        this.setHeight(simpleNode.getHeight());
        this.setRate(simpleNode.getRate());
        this.setId(simpleNode.getId());
        this.setNumber(simpleNode.getNumber());
        this.setTaxon(simpleNode.getTaxon());
        this.child = null;
        for (int i = 0; i < simpleNode.getChildCount(); ++i) {
            this.addChild(new SimpleNode(simpleNode.getChild(i)));
        }
    }

    public SimpleNode(Tree tree, NodeRef nodeRef) {
        this.setHeight(tree.getNodeHeight(nodeRef));
        this.setRate(tree.getNodeRate(nodeRef));
        int n = nodeRef.getNumber();
        this.setId(tree.getTaxonId(n));
        this.setNumber(n);
        this.setTaxon(tree.getNodeTaxon(nodeRef));
        this.child = null;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            this.addChild(new SimpleNode(tree, tree.getChild(nodeRef, i)));
        }
    }

    public SimpleNode getDeepCopy() {
        return new SimpleNode(this);
    }

    public final SimpleNode getParent() {
        return this.parent;
    }

    public void setParent(SimpleNode simpleNode) {
        this.parent = simpleNode;
    }

    public final double getHeight() {
        return this.height;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    public final double getRate() {
        return this.rate;
    }

    public final void setRate(double d) {
        this.rate = d;
    }

    @Override
    public void setNumber(int n) {
        this.nodeNumber = n;
    }

    @Override
    public int getNumber() {
        return this.nodeNumber;
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public SimpleNode getChild(int n) {
        assert (0 <= n && n < this.child.length);
        return this.child[n];
    }

    public boolean hasChild(SimpleNode simpleNode) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (simpleNode != this.child[i]) continue;
            return true;
        }
        return false;
    }

    public void addChild(SimpleNode simpleNode) {
        this.insertChild(simpleNode, this.getChildCount());
    }

    public void insertChild(SimpleNode simpleNode, int n) {
        int n2;
        int n3 = this.getChildCount();
        SimpleNode[] simpleNodeArray = new SimpleNode[n3 + 1];
        for (n2 = 0; n2 < n; ++n2) {
            simpleNodeArray[n2] = this.child[n2];
        }
        simpleNodeArray[n] = simpleNode;
        for (n2 = n; n2 < n3; ++n2) {
            simpleNodeArray[n2 + 1] = this.child[n2];
        }
        this.child = simpleNodeArray;
        simpleNode.setParent(this);
    }

    public SimpleNode removeChild(SimpleNode simpleNode) {
        int n = this.getChildCount();
        SimpleNode[] simpleNodeArray = new SimpleNode[n - 1];
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (this.child[i] != simpleNode) {
                simpleNodeArray[n2] = this.child[i];
                ++n2;
                continue;
            }
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("Nonexistent child");
        }
        simpleNode.setParent(null);
        this.child = simpleNodeArray;
        return simpleNode;
    }

    public SimpleNode removeChild(int n) {
        int n2 = this.getChildCount();
        if (n >= n2) {
            throw new IllegalArgumentException("Nonexistent child");
        }
        return this.removeChild(this.child[n]);
    }

    public void replaceChild(SimpleNode simpleNode, SimpleNode simpleNode2) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != simpleNode) continue;
            simpleNode2.setParent(this);
            this.child[i] = simpleNode2;
            break;
        }
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public boolean isExternal() {
        return !this.hasChildren();
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public final int getChildCount() {
        if (this.child == null) {
            return 0;
        }
        return this.child.length;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributeNames();
    }
}

