/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Likelihood;
import dr.inference.model.Statistic;
import java.util.ArrayList;

public class CoulombPrior
extends Likelihood.Abstract {
    protected ArrayList<Statistic> dataList = new ArrayList();
    private final double beta;

    public CoulombPrior(double d) {
        super(null);
        this.beta = d;
    }

    public void addData(Statistic statistic) {
        this.dataList.add(statistic);
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        for (Statistic statistic : this.dataList) {
            for (int i = 0; i < statistic.getDimension(); ++i) {
                d += -this.beta / statistic.getStatisticValue(i);
            }
        }
        return d;
    }

    @Override
    public String prettyName() {
        String string = "Coulomb(";
        for (Statistic statistic : this.dataList) {
            string = string + statistic.getStatisticName() + ",";
        }
        return string.substring(0, string.length() - 1) + ")";
    }
}

