/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evomodel.arg.ARGModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

public class ARGSwapOperator
extends SimpleMCMCOperator {
    public static final String ARG_SWAP_OPERATOR = "argSwapOperator";
    public static final String SWAP_TYPE = "type";
    public static final String BIFURCATION_SWAP = "bifurcationSwap";
    public static final String REASSORTMENT_SWAP = "reassortmentSwap";
    public static final String DUAL_SWAP = "dualSwap";
    public static final String FULL_SWAP = "fullSwap";
    public static final String NARROW_SWAP = "narrowSwap";
    private ARGModel arg;
    private String mode;
    private Comparator<NodeRef> NodeSorter = new Comparator<NodeRef>(){

        @Override
        public int compare(NodeRef nodeRef, NodeRef nodeRef2) {
            double[] dArray = new double[]{ARGSwapOperator.this.arg.getNodeHeight(nodeRef), ARGSwapOperator.this.arg.getNodeHeight(nodeRef2)};
            double[] dArray2 = dArray;
            if (dArray2[0] < dArray2[1]) {
                return -1;
            }
            if (dArray2[0] > dArray2[1]) {
                return 1;
            }
            return 0;
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private String[] validFormats = new String[]{"bifurcationSwap", "reassortmentSwap", "dualSwap", "fullSwap", "narrowSwap"};
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("weight"), new StringAttributeRule("type", "The mode of the operator", this.validFormats, false), new ElementRule(ARGModel.class)};

        @Override
        public String getParserDescription() {
            return "Swaps nodes on a tree";
        }

        @Override
        public Class getReturnType() {
            return ARGSwapOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute("weight");
            String string = xMLObject.getStringAttribute(ARGSwapOperator.SWAP_TYPE);
            Logger.getLogger("dr.evomodel").info("Creating ARGSwapOperator: " + string);
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            return new ARGSwapOperator(aRGModel, string, n);
        }

        @Override
        public String getParserName() {
            return ARGSwapOperator.ARG_SWAP_OPERATOR;
        }
    };

    public ARGSwapOperator(ARGModel aRGModel, String string, int n) {
        this.arg = aRGModel;
        this.mode = string;
        this.setWeight(n);
    }

    @Override
    public double doOperation() {
        if (this.mode.equals(NARROW_SWAP)) {
            return this.narrowSwap();
        }
        if ((this.mode.equals(REASSORTMENT_SWAP) || this.mode.equals(DUAL_SWAP)) && this.arg.getReassortmentNodeCount() == 0) {
            return 0.0;
        }
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>(this.arg.getNodeCount());
        ArrayList<NodeRef> arrayList2 = new ArrayList<NodeRef>(this.arg.getNodeCount());
        this.setupBifurcationNodes(arrayList);
        this.setupReassortmentNodes(arrayList2);
        if (this.mode.equals(BIFURCATION_SWAP)) {
            return this.bifurcationSwap(arrayList.get(MathUtils.nextInt(arrayList.size())));
        }
        if (this.mode.equals(REASSORTMENT_SWAP)) {
            return this.reassortmentSwap(arrayList2.get(MathUtils.nextInt(arrayList2.size())));
        }
        if (this.mode.equals(DUAL_SWAP)) {
            this.reassortmentSwap(arrayList2.get(MathUtils.nextInt(arrayList2.size())));
            return this.bifurcationSwap(arrayList.get(MathUtils.nextInt(arrayList.size())));
        }
        arrayList.addAll(arrayList2);
        Collections.sort(arrayList, this.NodeSorter);
        for (NodeRef nodeRef : arrayList) {
            if (this.arg.isBifurcation(nodeRef)) {
                this.bifurcationSwap(nodeRef);
                continue;
            }
            this.reassortmentSwap(nodeRef);
        }
        return 0.0;
    }

    private double narrowSwap() {
        ArrayList<NarrowSwap> arrayList = new ArrayList<NarrowSwap>(this.arg.getNodeCount());
        this.findAllNarrowSwaps(arrayList);
        int n = arrayList.size();
        if (n == 0) {
            return 0.0;
        }
        this.doNarrowSwap(arrayList.get(MathUtils.nextInt(arrayList.size())));
        arrayList.clear();
        this.findAllNarrowSwaps(arrayList);
        return Math.log((double)n / (double)arrayList.size());
    }

    public int findAllNarrowSwaps(ArrayList<NarrowSwap> arrayList) {
        int n = this.arg.getInternalNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getInternalNode(i);
            if (!node.bifurcation || node.isRoot() || !node.leftParent.bifurcation) continue;
            NarrowSwap narrowSwap = new NarrowSwap(node.leftChild, node, node.leftParent);
            NarrowSwap narrowSwap2 = new NarrowSwap(node.rightChild, node, node.leftParent);
            if (narrowSwap.isValid()) {
                arrayList.add(narrowSwap);
            }
            if (!narrowSwap2.isValid()) continue;
            arrayList.add(narrowSwap2);
        }
        return arrayList.size();
    }

    private void doNarrowSwap(NarrowSwap narrowSwap) {
        ARGModel.Node node;
        this.arg.beginTreeEdit();
        String string = this.arg.toARGSummary();
        if (narrowSwap.c == narrowSwap.pb) {
            node = (ARGModel.Node)narrowSwap.c;
            ARGModel.Node node2 = (ARGModel.Node)narrowSwap.p;
            ARGModel.Node node3 = (ARGModel.Node)narrowSwap.gp;
            if (node.leftParent == node2) {
                node.leftParent = node3;
                node.rightParent = node2;
            } else {
                node.leftParent = node2;
                node.rightParent = node3;
            }
        } else if (this.arg.getChild(narrowSwap.p, 0) == this.arg.getChild(narrowSwap.p, 1)) {
            node = (ARGModel.Node)narrowSwap.p;
            ARGModel.Node node4 = (ARGModel.Node)narrowSwap.c;
            if (MathUtils.nextBoolean()) {
                node4.leftParent = null;
                node.leftChild = null;
            } else {
                node4.rightParent = null;
                node.rightChild = null;
            }
            this.arg.removeChild(narrowSwap.gp, narrowSwap.pb);
            this.arg.singleAddChild(narrowSwap.gp, narrowSwap.c);
            this.arg.singleAddChild(narrowSwap.p, narrowSwap.pb);
        } else {
            this.arg.removeChild(narrowSwap.gp, narrowSwap.pb);
            this.arg.removeChild(narrowSwap.p, narrowSwap.c);
            this.arg.singleAddChild(narrowSwap.gp, narrowSwap.c);
            this.arg.singleAddChild(narrowSwap.p, narrowSwap.pb);
        }
        assert (this.nodeCheck()) : narrowSwap + " " + string + " " + this.arg.toARGSummary();
        this.arg.pushTreeChangedEvent(narrowSwap.gp);
        this.arg.pushTreeChangedEvent(narrowSwap.p);
        this.arg.endTreeEdit();
        try {
            this.arg.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            System.out.println(narrowSwap);
            System.out.println(string);
            System.err.println(invalidTreeException.getMessage());
            System.exit(-1);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(narrowSwap);
            System.out.println(string);
            System.err.println(nullPointerException.getMessage());
            System.exit(-1);
        }
    }

    private double bifurcationSwap(NodeRef nodeRef) {
        ARGModel.Node node = (ARGModel.Node)nodeRef;
        ARGModel.Node node2 = node.rightChild;
        if (MathUtils.nextBoolean()) {
            node2 = node.leftChild;
        }
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>(this.arg.getNodeCount());
        this.findNodesAtHeight(arrayList, node.getHeight());
        assert (!arrayList.contains(node));
        assert (arrayList.size() > 0);
        ARGModel.Node node3 = (ARGModel.Node)arrayList.get(MathUtils.nextInt(arrayList.size()));
        ARGModel.Node node4 = node3.leftParent;
        this.arg.beginTreeEdit();
        String string = this.arg.toARGSummary();
        if (node3.bifurcation) {
            node4 = node3.leftParent;
            this.arg.singleRemoveChild(node, node2);
            if (node4.bifurcation) {
                this.arg.singleRemoveChild(node4, node3);
                this.arg.singleAddChild(node4, node2);
            } else {
                this.arg.doubleRemoveChild(node4, node3);
                this.arg.doubleAddChild(node4, node2);
            }
            this.arg.singleAddChild(node, node3);
        } else {
            boolean bl = true;
            boolean[] blArray = new boolean[]{node3.leftParent.getHeight() > node.getHeight(), node3.rightParent.getHeight() > node.getHeight()};
            if (blArray[0] && blArray[1]) {
                if (MathUtils.nextBoolean()) {
                    node4 = node3.rightParent;
                    bl = false;
                }
            } else if (blArray[1]) {
                node4 = node3.rightParent;
                bl = false;
            }
            if (node3.leftParent == node3.rightParent) {
                this.arg.singleRemoveChild(node, node2);
                if (bl) {
                    node3.leftParent = null;
                    node4.leftChild = null;
                } else {
                    node3.rightParent = null;
                    node4.rightChild = null;
                }
                this.arg.singleAddChild(node, node3);
                this.arg.singleAddChild(node4, node2);
            } else if (node3.leftParent == node || node3.rightParent == node) {
                this.arg.singleRemoveChild(node, node2);
                if (node4.bifurcation) {
                    this.arg.singleRemoveChild(node4, node3);
                    this.arg.singleAddChild(node4, node2);
                } else {
                    this.arg.doubleRemoveChild(node4, node3);
                    this.arg.doubleAddChild(node4, node2);
                }
                if (node.leftChild == null) {
                    node.leftChild = node3;
                } else {
                    node.rightChild = node3;
                }
                if (node3.leftParent == null) {
                    node3.leftParent = node;
                } else {
                    node3.rightParent = node;
                }
            } else {
                this.arg.singleRemoveChild(node, node2);
                if (node4.bifurcation) {
                    this.arg.singleRemoveChild(node4, node3);
                    this.arg.singleAddChild(node4, node2);
                } else {
                    this.arg.doubleRemoveChild(node4, node3);
                    this.arg.doubleAddChild(node4, node2);
                }
                this.arg.singleAddChild(node, node3);
            }
        }
        this.arg.pushTreeChangedEvent();
        assert (this.nodeCheck());
        this.arg.endTreeEdit();
        try {
            this.arg.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            System.out.println(string);
            System.err.println(invalidTreeException.getMessage());
            System.exit(-1);
        }
        return 0.0;
    }

    private double reassortmentSwap(NodeRef nodeRef) {
        ARGModel.Node node = (ARGModel.Node)nodeRef;
        ARGModel.Node node2 = node.leftChild;
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>(this.arg.getNodeCount());
        this.findNodesAtHeight(arrayList, node.getHeight());
        assert (!arrayList.contains(node));
        assert (arrayList.size() > 0);
        ARGModel.Node node3 = (ARGModel.Node)arrayList.get(MathUtils.nextInt(arrayList.size()));
        this.arg.beginTreeEdit();
        if (node3.bifurcation) {
            ARGModel.Node node4 = node3.leftParent;
            this.arg.doubleRemoveChild(node, node2);
            if (node4.bifurcation) {
                this.arg.singleRemoveChild(node4, node3);
            } else {
                this.arg.doubleRemoveChild(node4, node3);
            }
            this.arg.doubleAddChild(node, node3);
            if (node2.bifurcation) {
                node2.leftParent = node4;
                node2.rightParent = node4;
            } else if (node2.leftParent == null) {
                node2.leftParent = node4;
            } else {
                node2.rightParent = node4;
            }
            if (!node4.bifurcation) {
                node4.leftChild = node2;
                node4.rightChild = node2;
            } else if (node4.leftChild == null) {
                node4.leftChild = node2;
            } else {
                node4.rightChild = node2;
            }
        } else {
            boolean bl = true;
            boolean[] blArray = new boolean[]{node3.leftParent.getHeight() > node.getHeight(), node3.rightParent.getHeight() > node.getHeight()};
            ARGModel.Node node5 = node3.leftParent;
            if (blArray[0] && blArray[1]) {
                if (MathUtils.nextBoolean()) {
                    bl = false;
                    node5 = node3.rightParent;
                }
            } else if (blArray[1]) {
                bl = false;
                node5 = node3.rightParent;
            }
            if (node3.leftParent == node3.rightParent) {
                this.arg.doubleRemoveChild(node, node2);
                if (bl) {
                    node3.leftParent = null;
                    node5.leftChild = null;
                    node5.leftChild = node2;
                    node3.leftParent = node;
                } else {
                    node3.rightParent = null;
                    node5.rightChild = null;
                    node5.rightChild = node2;
                    node3.rightParent = node;
                }
                node.leftChild = node.rightChild = node3;
                if (node2.bifurcation) {
                    node2.leftParent = node2.rightParent = node5;
                } else if (node2.leftParent == null) {
                    node2.leftParent = node5;
                } else {
                    node2.rightParent = node5;
                }
            } else {
                this.arg.doubleRemoveChild(node, node2);
                if (node5.bifurcation) {
                    this.arg.singleRemoveChild(node5, node3);
                } else {
                    this.arg.doubleRemoveChild(node5, node3);
                }
                node.leftChild = node.rightChild = node3;
                if (bl) {
                    node3.leftParent = node;
                } else {
                    node3.rightParent = node;
                }
                if (node5.bifurcation) {
                    if (node5.leftChild == null) {
                        node5.leftChild = node2;
                    } else {
                        node5.rightChild = node2;
                    }
                } else {
                    node5.leftChild = node5.rightChild = node2;
                }
                if (node2.bifurcation) {
                    node2.leftParent = node2.rightParent = node5;
                } else if (node2.leftParent == null) {
                    node2.leftParent = node5;
                } else {
                    node2.rightParent = node5;
                }
            }
        }
        this.arg.pushTreeChangedEvent();
        this.arg.endTreeEdit();
        try {
            this.arg.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            System.err.println(invalidTreeException.getMessage());
            System.exit(-1);
        }
        return 0.0;
    }

    private void setupBifurcationNodes(ArrayList<NodeRef> arrayList) {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = this.arg.getNode(i);
            if (!this.arg.isInternal(nodeRef) || !this.arg.isBifurcation(nodeRef) || this.arg.isRoot(nodeRef)) continue;
            arrayList.add(nodeRef);
        }
    }

    private void setupReassortmentNodes(ArrayList<NodeRef> arrayList) {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = this.arg.getNode(i);
            if (!this.arg.isReassortment(nodeRef)) continue;
            arrayList.add(nodeRef);
        }
    }

    private void findNodesAtHeight(ArrayList<NodeRef> arrayList, double d) {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (!(node.getHeight() < d)) continue;
            if (node.bifurcation) {
                if (!(node.leftParent.getHeight() > d)) continue;
                arrayList.add(node);
                continue;
            }
            if (node.leftParent.getHeight() > d) {
                arrayList.add(node);
            }
            if (!(node.rightParent.getHeight() > d)) continue;
            arrayList.add(node);
        }
    }

    @Override
    public String getOperatorName() {
        return this.mode;
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    public boolean nodeCheck() {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.leftParent != node.rightParent && node.leftChild != node.rightChild) {
                return false;
            }
            if (node.leftParent != null && node.leftParent.leftChild.getNumber() != i && node.leftParent.rightChild.getNumber() != i) {
                return false;
            }
            if (node.rightParent != null && node.rightParent.leftChild.getNumber() != i && node.rightParent.rightChild.getNumber() != i) {
                return false;
            }
            if (node.leftChild != null && node.leftChild.leftParent.getNumber() != i && node.leftChild.rightParent.getNumber() != i) {
                return false;
            }
            if (node.rightChild == null || node.rightChild.leftParent.getNumber() == i || node.rightChild.rightParent.getNumber() == i) continue;
            return false;
        }
        return true;
    }

    private class NarrowSwap {
        public NodeRef c;
        public NodeRef p;
        public NodeRef gp;
        public NodeRef pb;

        public NarrowSwap(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
            this.c = nodeRef;
            this.p = nodeRef2;
            this.gp = nodeRef3;
            this.pb = ARGSwapOperator.this.arg.getOtherChild(nodeRef3, nodeRef2);
        }

        public boolean isValid() {
            return ARGSwapOperator.this.arg.getNodeHeight(this.pb) < ARGSwapOperator.this.arg.getNodeHeight(this.p);
        }

        public String toString() {
            return "Child: " + this.c.toString() + ", Parent: " + this.p.toString() + ", G-parent: " + this.gp.toString() + ", P-brother: " + this.pb.toString();
        }
    }
}

