/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RecombinationHeightBoundStatistic
extends TreeStatistic {
    private Tree tree;
    private final List<Set<String>> leafSets;
    private final double mostRecentTipTime;
    private final boolean isBackwards;

    public RecombinationHeightBoundStatistic(String string, Tree tree, List<TaxonList> list, boolean bl) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.leafSets = new ArrayList<Set<String>>();
        for (TaxonList taxonList : list) {
            this.leafSets.add(TreeUtils.getLeavesForTaxa(tree, taxonList));
        }
        if (bl && Taxon.getMostRecentDate() != null) {
            this.isBackwards = Taxon.getMostRecentDate().isBackwards();
            this.mostRecentTipTime = Taxon.getMostRecentDate().getAbsoluteTimeValue();
        } else {
            this.mostRecentTipTime = Double.NaN;
            this.isBackwards = false;
        }
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getStatisticValue(int n) {
        double d;
        if (n == 0) {
            d = this.getMaxHeight();
        } else if (n == 1) {
            d = this.getMinHeight();
        } else {
            throw new IllegalArgumentException("Unknown dimension");
        }
        return this.transformHeight(d);
    }

    private double getMaxHeight() {
        double d = Double.NEGATIVE_INFINITY;
        for (Set<String> set : this.leafSets) {
            NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.tree, set);
            if (this.tree.isRoot(nodeRef)) {
                return this.tree.getNodeHeight(this.tree.getRoot());
            }
            d = Math.max(d, this.tree.getNodeHeight(this.tree.getParent(nodeRef)));
        }
        return d;
    }

    private double getMinHeight() {
        double d = Double.POSITIVE_INFINITY;
        for (Set<String> set : this.leafSets) {
            NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.tree, set);
            d = Math.min(d, this.tree.getNodeHeight(nodeRef));
        }
        return d;
    }

    private double transformHeight(double d) {
        if (!Double.isNaN(this.mostRecentTipTime)) {
            if (this.isBackwards) {
                return this.mostRecentTipTime + d;
            }
            return this.mostRecentTipTime - d;
        }
        return d;
    }
}

