/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.traverse.DepthFirstIterator;

public class CycleDetector<V, E> {
    DirectedGraph<V, E> graph;

    public CycleDetector(DirectedGraph<V, E> graph) {
        this.graph = graph;
    }

    public boolean detectCycles() {
        try {
            this.execute(null, null);
        }
        catch (CycleDetectedException ex) {
            return true;
        }
        return false;
    }

    public boolean detectCyclesContainingVertex(V v) {
        try {
            this.execute(null, v);
        }
        catch (CycleDetectedException ex) {
            return true;
        }
        return false;
    }

    public Set<V> findCycles() {
        StrongConnectivityInspector<V, E> inspector = new StrongConnectivityInspector<V, E>(this.graph);
        List<Set<V>> components = inspector.stronglyConnectedSets();
        HashSet<V> set = new HashSet<V>();
        for (Set<V> component : components) {
            if (component.size() > 1) {
                set.addAll(component);
                continue;
            }
            V v = component.iterator().next();
            if (!this.graph.containsEdge(v, v)) continue;
            set.add(v);
        }
        return set;
    }

    public Set<V> findCyclesContainingVertex(V v) {
        HashSet set = new HashSet();
        this.execute(set, v);
        return set;
    }

    private void execute(Set<V> s, V v) {
        ProbeIterator iter = new ProbeIterator(s, v);
        while (iter.hasNext()) {
            iter.next();
        }
    }

    private class ProbeIterator
    extends DepthFirstIterator<V, E> {
        private List<V> path;
        private Set<V> cycleSet;
        private V root;

        ProbeIterator(Set<V> cycleSet, V startVertex) {
            super(CycleDetector.this.graph, startVertex);
            this.root = startVertex;
            this.cycleSet = cycleSet;
            this.path = new ArrayList();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void encounterVertexAgain(V vertex, E edge) {
            int i;
            super.encounterVertexAgain(vertex, edge);
            if (this.root != null) {
                if (vertex.equals(this.root)) {
                    i = 0;
                } else {
                    if (this.cycleSet == null || !this.cycleSet.contains(vertex)) return;
                    i = 0;
                }
            } else {
                i = this.path.indexOf(vertex);
            }
            if (i <= -1) return;
            if (this.cycleSet == null) {
                throw new CycleDetectedException();
            }
            while (i < this.path.size()) {
                this.cycleSet.add(this.path.get(i));
                ++i;
            }
        }

        @Override
        protected V provideNextVertex() {
            Object v = super.provideNextVertex();
            for (int i = this.path.size() - 1; i >= 0 && !CycleDetector.this.graph.containsEdge(this.path.get(i), v); --i) {
                this.path.remove(i);
            }
            this.path.add(v);
            return v;
        }
    }

    private static class CycleDetectedException
    extends RuntimeException {
        private static final long serialVersionUID = 3834305137802950712L;

        private CycleDetectedException() {
        }
    }
}

