/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.TwoStateCovarion;
import dr.evomodel.substmodel.AbstractCovarionModel;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.BinaryCovarionModel;
import dr.oldevomodel.substmodel.SubstitutionModelUtils;

public class BinaryCovarionModel
extends AbstractCovarionModel {
    private Parameter alpha;
    private Parameter switchRate;
    private Parameter frequencies;
    private Parameter hiddenFrequencies;
    private final BinaryCovarionModel.Version version;

    public BinaryCovarionModel(TwoStateCovarion twoStateCovarion, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, BinaryCovarionModel.Version version) {
        super("binaryCovarionModel", (DataType)twoStateCovarion, parameter, parameter2);
        this.alpha = parameter3;
        this.switchRate = parameter4;
        this.frequencies = parameter;
        this.hiddenFrequencies = parameter2;
        this.version = version;
        this.addVariable(this.alpha);
        this.addVariable(this.switchRate);
        this.addVariable(parameter);
        this.addVariable(parameter2);
    }

    @Override
    protected void setupQMatrix(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d = this.alpha.getParameterValue(0);
        double d2 = this.switchRate.getParameterValue(0);
        double d3 = this.hiddenFrequencies.getParameterValue(0);
        double d4 = this.hiddenFrequencies.getParameterValue(1);
        double d5 = this.frequencies.getParameterValue(0);
        double d6 = this.frequencies.getParameterValue(1);
        assert (Math.abs(1.0 - d3 - d4) < 1.0E-8);
        assert (Math.abs(1.0 - d5 - d6) < 1.0E-8);
        d3 = this.version.getF0(d3);
        d4 = this.version.getF1(d4);
        dArray3[0][1] = d * d6;
        dArray3[0][2] = d2 * d3;
        dArray3[0][3] = 0.0;
        dArray3[1][0] = d * d5;
        dArray3[1][2] = 0.0;
        dArray3[1][3] = d2 * d3;
        dArray3[2][0] = d2 * d4;
        dArray3[2][1] = 0.0;
        dArray3[2][3] = d6;
        dArray3[3][0] = 0.0;
        dArray3[3][1] = d2 * d4;
        dArray3[3][2] = d5;
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    public String toString() {
        int n = this.dataType.getStateCount();
        double[] dArray = new double[n * n];
        this.getInfinitesimalMatrix(dArray);
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = dArray[i * n + j];
            }
        }
        this.setupQMatrix(null, null, dArray2);
        return SubstitutionModelUtils.toString(dArray2, this.dataType, 2);
    }

    @Override
    protected double getNormalizationValue(double[][] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        int n2 = dArray2.length;
        for (n = 0; n < n2; ++n) {
            d += -dArray[n][n] * dArray2[n];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                dArray[n][i] = dArray[n][i] / d;
            }
        }
        double d2 = 0.0;
        d2 += dArray[0][2] * dArray2[2];
        d2 += dArray[2][0] * dArray2[0];
        d2 += dArray[1][3] * dArray2[3];
        d2 += dArray[3][1] * dArray2[1];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = dArray[i][j] / (1.0 - d2);
            }
        }
        return 1.0;
    }
}

