/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.cp.common.util.preprocessor.detector.scheduling.AbstractTemporalDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.TemporalConstraint;

public final class DisjointModelDetector
extends AbstractTemporalDetector {
    public DisjointModelDetector(CPModel model, DisjunctiveModel disjMod) {
        super(model, disjMod);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.disjMod.setPrecClosure();
    }

    @Override
    protected void apply(TemporalConstraint ct) {
        if (!ct.isFixed()) {
            DisjunctiveModel.AddEdgeStatus status = this.disjMod.safeAddEdge(ct);
            if (status.deleteC) {
                this.delete(ct);
            }
            if (status.repV != null) {
                this.replaceBy(ct.getDirection(), status.repV);
            }
            if (status.oppV != null) {
                this.replaceBy(ct.getDirection(), status.oppV);
            }
        }
    }

    @Override
    protected ConstraintType getType() {
        return ConstraintType.PRECEDENCE_DISJOINT;
    }
}

