/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.transformation;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.transformation.DataTransformation;
import jdplus.toolkit.base.core.data.transformation.LogJacobian;
import jdplus.toolkit.base.core.data.transformation.LogTransformation;

public class ExpTransformation
implements DataTransformation {
    public static final ExpTransformation EXEMPLAR = new ExpTransformation();

    public boolean canTransform(DoubleSeq data) {
        return true;
    }

    @Override
    public DataTransformation converse() {
        return LogTransformation.EXEMPLAR;
    }

    @Override
    public DoubleSeq transform(DoubleSeq data, LogJacobian ljacobian) {
        double[] x = data.toArray();
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.exp(x[i]);
        }
        if (ljacobian != null) {
            double s = 0.0;
            if (ljacobian.missing == null) {
                for (int i = ljacobian.start; i < ljacobian.end; ++i) {
                    if (!Double.isFinite(x[i])) continue;
                    s += x[i];
                }
            } else {
                int imissing;
                int nmissing = ljacobian.missing.length;
                int ic = ljacobian.start;
                for (imissing = 0; imissing < nmissing && ljacobian.missing[imissing] < ic; ++imissing) {
                }
                while (imissing != nmissing && ic < ljacobian.end) {
                    if (ic == ljacobian.missing[imissing]) {
                        ++ic;
                        ++imissing;
                        continue;
                    }
                    s += x[ic++];
                }
                while (ic < ljacobian.end) {
                    s += x[ic++];
                }
            }
            ljacobian.value += s;
        }
        return DoubleSeq.of((double[])x);
    }

    @Override
    public double transform(double x) {
        return Math.exp(x);
    }
}

