/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class BoxPierce {
    private int lag = 1;
    private int k = 12;
    private int nhp;
    private int sign;
    private final IntToDoubleFunction autoCorrelations;
    private final int n;

    public BoxPierce(DoubleSeq sample) {
        this(sample, false);
    }

    public BoxPierce(DoubleSeq sample, boolean correctForMean) {
        if (correctForMean) {
            this.autoCorrelations = AutoCovariances.autoCorrelationFunction((DoubleSeq)sample, (double)sample.average());
            this.n = sample.length() - 1;
        } else {
            this.autoCorrelations = AutoCovariances.autoCorrelationFunction((DoubleSeq)sample, (double)0.0);
            this.n = sample.length();
        }
    }

    public BoxPierce(IntToDoubleFunction autoCorrelations, int sampleSize) {
        this.autoCorrelations = autoCorrelations;
        this.n = sampleSize;
    }

    public BoxPierce hyperParametersCount(int nhp) {
        this.nhp = nhp;
        return this;
    }

    public BoxPierce lag(int lag) {
        this.lag = lag;
        return this;
    }

    public BoxPierce autoCorrelationsCount(int k) {
        this.k = k;
        return this;
    }

    public BoxPierce usePositiveAutoCorrelations() {
        this.sign = 1;
        return this;
    }

    public BoxPierce useNegativeAutoCorrelations() {
        this.sign = -1;
        return this;
    }

    public BoxPierce useAllAutoCorrelations() {
        this.sign = 0;
        return this;
    }

    public StatisticalTest build() {
        double res = 0.0;
        for (int i = 1; i <= this.k; ++i) {
            double ai = this.autoCorrelations.applyAsDouble(i * this.lag);
            if (!(this.sign == 0 || this.sign == 1 && ai > 0.0) && (this.sign != -1 || !(ai < 0.0))) continue;
            res += ai * ai;
        }
        double val = res * (double)this.n;
        Chi2 chi = new Chi2(this.lag == 1 ? (double)(this.k - this.nhp) : (double)this.k);
        return TestsUtility.testOf(val, chi, TestType.Upper);
    }
}

