/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.AbstractCoalescentLikelihood;
import dr.evomodel.coalescent.PopulationSizeFunction;
import dr.evomodel.coalescent.PopulationSizeModel;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.math.Binomial;
import java.util.logging.Logger;

public final class CoalescentLikelihood
extends AbstractCoalescentLikelihood
implements Units {
    private final PopulationSizeModel populationSizeModel;
    private final DemographicModel demographicModel;
    private double[] coalescentEventStatisticValues;

    public CoalescentLikelihood(IntervalList intervalList, DemographicModel demographicModel) {
        super("coalescentLikelihood", intervalList);
        this.populationSizeModel = null;
        this.demographicModel = demographicModel;
        this.coalescentEventStatisticValues = new double[this.getNumberOfCoalescentEvents()];
        this.addModel(demographicModel);
    }

    public CoalescentLikelihood(IntervalList intervalList, PopulationSizeModel populationSizeModel) {
        super("coalescentLikelihood", intervalList);
        this.populationSizeModel = populationSizeModel;
        this.demographicModel = null;
        this.coalescentEventStatisticValues = new double[this.getNumberOfCoalescentEvents()];
        this.addModel(populationSizeModel);
    }

    @Override
    protected double calculateLogLikelihood() {
        double d;
        if (this.populationSizeModel != null) {
            PopulationSizeFunction populationSizeFunction = this.populationSizeModel.getPopulationSizeFunction();
            d = this.calculateLogLikelihood(populationSizeFunction);
        } else {
            d = this.calculateLogLikelihood(this.demographicModel);
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            Logger.getLogger("warning").severe("CoalescentLikelihood for " + this.demographicModel.getId() + " is " + Double.toString(d));
        }
        return d;
    }

    protected double calculateLogLikelihood(DemographicModel demographicModel) {
        double d = 0.0;
        IntervalList intervalList = this.getIntervalList();
        int n = intervalList.getIntervalCount();
        if (n == 0) {
            return 0.0;
        }
        double d2 = intervalList.getStartTime();
        demographicModel.setTimeOffset(d2);
        DemographicFunction demographicFunction = demographicModel.getDemographicFunction();
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = intervalList.getInterval(i);
            double d5 = d3 + d4;
            double d6 = demographicFunction.getIntegral(d3, d5);
            if (d6 == 0.0 && d4 != 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            int n2 = intervalList.getLineageCount(i);
            double d7 = Binomial.choose2(n2);
            d += -d7 * d6;
            if (intervalList.getIntervalType(i) == IntervalType.COALESCENT) {
                double d8 = demographicFunction.getDemographic(d5);
                if (d4 == 0.0 || d8 * (d6 / d4) >= demographicFunction.getThreshold()) {
                    d -= Math.log(d8);
                } else {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            d3 = d5;
        }
        return d;
    }

    protected double calculateLogLikelihood(PopulationSizeFunction populationSizeFunction) {
        double d = 0.0;
        IntervalList intervalList = this.getIntervalList();
        int n = intervalList.getIntervalCount();
        if (n == 0) {
            return 0.0;
        }
        double d2 = intervalList.getStartTime();
        this.demographicModel.setTimeOffset(d2);
        DemographicFunction demographicFunction = this.demographicModel.getDemographicFunction();
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = intervalList.getInterval(i);
            double d5 = d3 + d4;
            double d6 = populationSizeFunction.getIntegral(d3, d5);
            if (d6 == 0.0 && d4 != 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            int n2 = intervalList.getLineageCount(i);
            double d7 = Binomial.choose2(n2);
            d += -d7 * d6;
            if (intervalList.getIntervalType(i) == IntervalType.COALESCENT) {
                d -= populationSizeFunction.getLogDemographic(d5);
            }
            d3 = d5;
        }
        return d;
    }

    public DemographicModel getDemoModel() {
        return this.demographicModel;
    }

    @Override
    public int getNumberOfCoalescentEvents() {
        return this.getIntervalList().getIntervalCount() / 2;
    }

    @Override
    public double getCoalescentEventsStatisticValue(int n) {
        if (n == 0) {
            int n2;
            IntervalList intervalList = this.getIntervalList();
            int n3 = intervalList.getIntervalCount();
            for (n2 = 0; n2 < this.coalescentEventStatisticValues.length; ++n2) {
                this.coalescentEventStatisticValues[n2] = 0.0;
            }
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                if (intervalList.getIntervalType(i) == IntervalType.COALESCENT) {
                    int n4 = n2++;
                    this.coalescentEventStatisticValues[n4] = this.coalescentEventStatisticValues[n4] + intervalList.getInterval(i) * ((double)intervalList.getLineageCount(i) * ((double)intervalList.getLineageCount(i) - 1.0)) / 2.0;
                    continue;
                }
                int n5 = n2;
                this.coalescentEventStatisticValues[n5] = this.coalescentEventStatisticValues[n5] + intervalList.getInterval(i) * ((double)intervalList.getLineageCount(i) * ((double)intervalList.getLineageCount(i) - 1.0)) / 2.0;
            }
        }
        return this.coalescentEventStatisticValues[n];
    }

    public PopulationSizeModel getPopulationSizeModel() {
        return this.populationSizeModel;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.demographicModel.setUnits(type);
    }

    @Override
    public final Units.Type getUnits() {
        return this.demographicModel.getUnits();
    }
}

