/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.integration;

import internal.toolkit.base.core.math.functions.gsl.integration.QAGS;
import internal.toolkit.base.core.math.functions.gsl.integration.QK15;
import java.util.function.DoubleUnaryOperator;
import lombok.Generated;

final class NumericalIntegration {
    static double integrate(DoubleUnaryOperator fn, double a, double b) {
        try {
            QAGS qags = QAGS.builder().absoluteTolerance(1.0E-9).build();
            qags.integrate(fn, a, b);
            return qags.getResult();
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    static double integrateQAGI(DoubleUnaryOperator fn) {
        try {
            QAGS qags = QAGS.builder().absoluteTolerance(1.0E-9).integrationRule(QK15.rule()).build();
            qags.integrate(d -> {
                double x = (1.0 - d) / d;
                double y = fn.applyAsDouble(x) + fn.applyAsDouble(-x);
                return y / d / d;
            }, 0.0, 1.0);
            return qags.getResult();
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    static double integrateQAGIL(DoubleUnaryOperator fn, double b) {
        try {
            QAGS qags = QAGS.builder().absoluteTolerance(1.0E-9).integrationRule(QK15.rule()).build();
            qags.integrate(d -> {
                double x = b - (1.0 - d) / d;
                double y = fn.applyAsDouble(x);
                return y / d / d;
            }, 0.0, 1.0);
            return qags.getResult();
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    static double integrateQAGIU(DoubleUnaryOperator fn, double a) {
        try {
            QAGS qags = QAGS.builder().absoluteTolerance(1.0E-9).integrationRule(QK15.rule()).build();
            qags.integrate(d -> {
                double x = a + (1.0 - d) / d;
                double y = fn.applyAsDouble(x);
                return y / d / d;
            }, 0.0, 1.0);
            return qags.getResult();
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    @Generated
    private NumericalIntegration() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

