/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information.formatters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.information.InformationSet;
import jdplus.toolkit.base.api.information.formatters.BooleanFormatter;
import jdplus.toolkit.base.api.information.formatters.ComplexFormatter;
import jdplus.toolkit.base.api.information.formatters.DiagnosticFormatter;
import jdplus.toolkit.base.api.information.formatters.DoubleFormatter;
import jdplus.toolkit.base.api.information.formatters.InformationFormatter;
import jdplus.toolkit.base.api.information.formatters.IntegerFormatter;
import jdplus.toolkit.base.api.information.formatters.LongFormatter;
import jdplus.toolkit.base.api.information.formatters.ParameterFormatter;
import jdplus.toolkit.base.api.information.formatters.PeriodFormatter;
import jdplus.toolkit.base.api.information.formatters.RegressionItemFormatter;
import jdplus.toolkit.base.api.information.formatters.SarimaFormatter;
import jdplus.toolkit.base.api.information.formatters.StatisticalTestFormatter;
import jdplus.toolkit.base.api.information.formatters.StringArrayFormatter;
import jdplus.toolkit.base.api.information.formatters.StringFormatter;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.RegressionItem;
import jdplus.toolkit.base.api.util.Table;
import lombok.Generated;

public final class TableFormatter {
    private static final HashMap<Class, InformationFormatter> DICTIONARY = new HashMap();
    private static Locale LOCALE;

    public static Table<String> formatInformation(List<InformationSet> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split(name));
        }
        int[] witems = new int[snames.size()];
        int ncols = 0;
        int icur = 0;
        for (String[] sname : snames) {
            String slast = sname[sname.length - 1];
            int l = slast.indexOf(58);
            int w = 1;
            if (l >= 0) {
                String s0 = slast.substring(0, l);
                String s1 = slast.substring(l + 1);
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            witems[icur] = w;
            ncols = w < 0 ? ++ncols : (ncols += w);
            ++icur;
        }
        Table<String> rslt = new Table<String>(records.size(), ncols);
        int row = 0;
        for (InformationSet record : records) {
            if (record == null) continue;
            int c = 0;
            int col = 0;
            for (String[] cnames : snames) {
                int n = witems[c++];
                Object obj = record.search(cnames, Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.set(row, col++, TableFormatter.format(obj, 0));
                        continue;
                    }
                    if (n < 0) {
                        rslt.set(row, col++, TableFormatter.format(obj, n));
                        continue;
                    }
                    for (int j = 1; j <= n; ++j) {
                        rslt.set(row, col++, TableFormatter.format(obj, j));
                    }
                    continue;
                }
                if (n < 0) {
                    ++col;
                    continue;
                }
                col += n;
            }
            ++row;
        }
        return rslt;
    }

    public static Table<String> formatProcResults(List<Explorable> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split(name));
        }
        int[] witems = new int[snames.size()];
        int ncols = 0;
        int icur = 0;
        for (String[] sname : snames) {
            String slast = sname[sname.length - 1];
            int l = slast.indexOf(58);
            int w = 1;
            if (l >= 0) {
                String s0 = slast.substring(0, l);
                String s1 = slast.substring(l + 1);
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            witems[icur] = w;
            ncols = w < 0 ? ++ncols : (ncols += w);
            ++icur;
        }
        Table<String> rslt = new Table<String>(records.size(), ncols);
        int row = 0;
        for (Explorable record : records) {
            if (record == null) continue;
            int c = 0;
            int col = 0;
            for (String[] cnames : snames) {
                int n = witems[c++];
                Object obj = record.getData(InformationSet.concatenate(cnames), Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.set(row, col++, TableFormatter.format(obj, 0));
                        continue;
                    }
                    if (n < 0) {
                        rslt.set(row, col++, TableFormatter.format(obj, n));
                        continue;
                    }
                    if (n <= 1) continue;
                    for (int j = 1; j <= n; ++j) {
                        rslt.set(row, col++, TableFormatter.format(obj, j));
                    }
                    continue;
                }
                if (n < 0) {
                    ++col;
                    continue;
                }
                col += n;
            }
            ++row;
        }
        return rslt;
    }

    private static String format(Object obj, int item) {
        try {
            if (obj != null && obj.getClass().isArray()) {
                Object[] array = (Object[])obj;
                InformationFormatter fmt = DICTIONARY.get(array[0].getClass());
                Object[] rslt = Arrays.stream(array).map(i -> fmt.format(i, item, LOCALE)).toArray();
                return Arrays.toString(rslt);
            }
            InformationFormatter fmt = DICTIONARY.get(obj.getClass());
            return fmt.format(obj, item, LOCALE);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (item == 0) {
                return obj.toString();
            }
            return "";
        }
    }

    @Generated
    private TableFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        DICTIONARY.put(Double.TYPE, new DoubleFormatter());
        DICTIONARY.put(Integer.TYPE, new IntegerFormatter());
        DICTIONARY.put(Long.TYPE, new LongFormatter());
        DICTIONARY.put(Boolean.TYPE, new BooleanFormatter("1", "0"));
        DICTIONARY.put(Double.class, new DoubleFormatter());
        DICTIONARY.put(Integer.class, new IntegerFormatter());
        DICTIONARY.put(Long.class, new LongFormatter());
        DICTIONARY.put(Boolean.class, new BooleanFormatter("1", "0"));
        DICTIONARY.put(Complex.class, new ComplexFormatter());
        DICTIONARY.put(String.class, new StringFormatter());
        DICTIONARY.put(String[].class, new StringArrayFormatter());
        DICTIONARY.put(SarimaOrders.class, new SarimaFormatter());
        DICTIONARY.put(Parameter.class, new ParameterFormatter());
        DICTIONARY.put(TsPeriod.class, new PeriodFormatter());
        DICTIONARY.put(RegressionItem.class, new RegressionItemFormatter());
        DICTIONARY.put(StatisticalTest.class, new StatisticalTestFormatter());
        DICTIONARY.put(ProcDiagnostic.class, new DiagnosticFormatter());
        LOCALE = Locale.getDefault();
    }
}

