/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.colt.matrix.linalg.Property;
import dr.evolution.datatype.DataType;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.RobustEigenDecomposition;
import dr.math.matrixAlgebra.RobustSingularValueDecomposition;
import dr.oldevomodel.substmodel.AbstractSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ComplexSubstitutionModel
extends AbstractSubstitutionModel
implements Likelihood,
Citable {
    protected Parameter infinitesimalRates;
    private boolean isComplex = false;
    private double[] stationaryDistribution = null;
    private double[] storedStationaryDistribution;
    protected boolean doNormalization = true;
    protected double[] EvalImag;
    protected double[] storedEvalImag;
    protected boolean wellConditioned = true;
    private boolean storedWellConditioned;
    protected static final double minProb = Property.DEFAULT.tolerance();
    private static final Algebra alegbra = new Algebra(minProb);
    EigenvalueDecomposition eigenDecomp;
    EigenvalueDecomposition storedEigenDecomp;
    private double maxConditionNumber = 1000.0;
    private int maxIterations = 1000;
    private boolean checkConditioning = true;
    private boolean isUsed = false;
    private double[] probability = null;

    public ComplexSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, Parameter parameter) {
        super(string, dataType, frequencyModel);
        this.infinitesimalRates = parameter;
        this.rateCount = this.stateCount * (this.stateCount - 1);
        if (parameter != null) {
            if (this.rateCount != this.infinitesimalRates.getDimension()) {
                throw new RuntimeException("Dimension of '" + this.infinitesimalRates.getId() + "' (" + this.infinitesimalRates.getDimension() + ") must equal " + this.rateCount);
            }
            this.addVariable(this.infinitesimalRates);
        }
        this.stationaryDistribution = new double[this.stateCount];
        this.storedStationaryDistribution = new double[this.stateCount];
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.freqModel) {
            return;
        }
        super.handleModelChangedEvent(model, object, n);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.updateMatrix = true;
    }

    @Override
    protected void restoreState() {
        double[] dArray = this.storedEvalImag;
        this.storedEvalImag = this.EvalImag;
        this.EvalImag = dArray;
        dArray = this.storedStationaryDistribution;
        this.storedStationaryDistribution = this.stationaryDistribution;
        this.stationaryDistribution = dArray;
        this.updateMatrix = this.storedUpdateMatrix;
        this.wellConditioned = this.storedWellConditioned;
        double[] dArray2 = this.storedEval;
        this.storedEval = this.Eval;
        this.Eval = dArray2;
        double[][] dArray3 = this.storedIevc;
        this.storedIevc = this.Ievc;
        this.Ievc = dArray3;
        dArray3 = this.storedEvec;
        this.storedEvec = this.Evec;
        this.Evec = dArray3;
    }

    @Override
    protected void storeState() {
        this.storedUpdateMatrix = this.updateMatrix;
        this.storedWellConditioned = this.wellConditioned;
        System.arraycopy(this.stationaryDistribution, 0, this.storedStationaryDistribution, 0, this.stateCount);
        System.arraycopy(this.EvalImag, 0, this.storedEvalImag, 0, this.stateCount);
        System.arraycopy(this.Eval, 0, this.storedEval, 0, this.stateCount);
        for (int i = 0; i < this.stateCount; ++i) {
            System.arraycopy(this.Ievc[i], 0, this.storedIevc[i], 0, this.stateCount);
            System.arraycopy(this.Evec[i], 0, this.storedEvec[i], 0, this.stateCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        int n;
        int n2;
        double d2;
        int n3;
        Object object = this;
        synchronized (object) {
            if (this.updateMatrix) {
                this.setupMatrix();
            }
        }
        if (!this.wellConditioned) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        object = this.popiexp();
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            if (this.EvalImag[n3] == 0.0) {
                d2 = Math.exp(d * this.Eval[n3]);
                for (n2 = 0; n2 < this.stateCount; ++n2) {
                    object[n3][n2] = this.Ievc[n3][n2] * d2;
                }
                continue;
            }
            n = n3 + 1;
            double d3 = this.EvalImag[n3];
            double d4 = Math.exp(d * this.Eval[n3]);
            double d5 = d4 * Math.cos(d * d3);
            double d6 = d4 * Math.sin(d * d3);
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                object[n3][n2] = d5 * this.Ievc[n3][n2] + d6 * this.Ievc[n][n2];
                object[n][n2] = d5 * this.Ievc[n][n2] - d6 * this.Ievc[n3][n2];
            }
            ++n3;
        }
        n = 0;
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                d2 = 0.0;
                for (int i = 0; i < this.stateCount; ++i) {
                    d2 += this.Evec[n3][i] * object[i][n2];
                }
                dArray[n] = d2 < 0.0 ? minProb : d2;
                ++n;
            }
        }
        this.pushiexp((double[][])object);
    }

    public double[] getStationaryDistribution() {
        return this.stationaryDistribution;
    }

    protected void computeStationaryDistribution() {
        this.stationaryDistribution = this.freqModel.getFrequencies();
    }

    protected double[] getRates() {
        return this.infinitesimalRates.getParameterValues();
    }

    protected double[] getPi() {
        return this.freqModel.getFrequencies();
    }

    @Override
    public void setupMatrix() {
        DoubleMatrix2D doubleMatrix2D;
        RobustEigenDecomposition robustEigenDecomposition;
        if (!this.eigenInitialised) {
            this.initialiseEigen();
            this.storedEvalImag = new double[this.stateCount];
        }
        int n = 0;
        this.storeIntoAmat();
        this.makeValid(this.amat, this.stateCount);
        try {
            robustEigenDecomposition = new RobustEigenDecomposition(new DenseDoubleMatrix2D(this.amat), this.maxIterations);
        }
        catch (ArithmeticException arithmeticException) {
            System.err.println(arithmeticException.getMessage());
            this.wellConditioned = false;
            System.err.println("amat = \n" + new Matrix(this.amat));
            return;
        }
        DoubleMatrix2D doubleMatrix2D2 = robustEigenDecomposition.getV();
        DoubleMatrix1D doubleMatrix1D = robustEigenDecomposition.getRealEigenvalues();
        DoubleMatrix1D doubleMatrix1D2 = robustEigenDecomposition.getImagEigenvalues();
        if (this.checkConditioning) {
            RobustSingularValueDecomposition robustSingularValueDecomposition;
            try {
                robustSingularValueDecomposition = new RobustSingularValueDecomposition(doubleMatrix2D2, this.maxIterations);
            }
            catch (ArithmeticException arithmeticException) {
                System.err.println(arithmeticException.getMessage());
                this.wellConditioned = false;
                return;
            }
            if (robustSingularValueDecomposition.cond() > this.maxConditionNumber) {
                this.wellConditioned = false;
                return;
            }
        }
        try {
            doubleMatrix2D = alegbra.inverse(doubleMatrix2D2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.wellConditioned = false;
            return;
        }
        this.Ievc = doubleMatrix2D.toArray();
        this.Evec = doubleMatrix2D2.toArray();
        this.Eval = doubleMatrix1D.toArray();
        this.EvalImag = doubleMatrix1D2.toArray();
        for (n = 0; n < this.stateCount; ++n) {
            if (Double.isNaN(this.Eval[n]) || Double.isNaN(this.EvalImag[n]) || Double.isInfinite(this.Eval[n]) || Double.isInfinite(this.EvalImag[n])) {
                this.wellConditioned = false;
                return;
            }
            if (!(Math.abs(this.Eval[n]) < 1.0E-10)) continue;
            this.Eval[n] = 0.0;
        }
        this.updateMatrix = false;
        this.wellConditioned = true;
        this.computeStationaryDistribution();
        if (this.doNormalization) {
            double d = 0.0;
            for (n = 0; n < this.stateCount; ++n) {
                d += -this.amat[n][n] * this.stationaryDistribution[n];
            }
            n = 0;
            while (n < this.stateCount) {
                int n2 = n;
                this.Eval[n2] = this.Eval[n2] / d;
                int n3 = n++;
                this.EvalImag[n3] = this.EvalImag[n3] / d;
            }
        }
    }

    public void storeIntoAmat() {
        int n;
        int n2;
        double[] dArray = this.getRates();
        double[] dArray2 = this.getPi();
        int n3 = 0;
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            for (n = n2 + 1; n < this.stateCount; ++n) {
                this.amat[n2][n] = dArray[n3++] * dArray2[n];
            }
        }
        for (n = 0; n < this.stateCount; ++n) {
            for (n2 = n + 1; n2 < this.stateCount; ++n2) {
                this.amat[n2][n] = dArray[n3++] * dArray2[n];
            }
        }
    }

    private void printDebugSetupMatrix() {
        System.out.println("Normalized infinitesimal rate matrix:");
        System.out.println(new Matrix(this.amat));
        System.out.println(new Matrix(this.amat).toStringOctave());
        System.out.println("Values in setupMatrix():");
    }

    protected void checkComplexSolutions() {
        boolean bl = false;
        for (int i = 0; i < this.stateCount && !bl; ++i) {
            if (this.EvalImag[i] == 0.0) continue;
            bl = true;
        }
        this.isComplex = bl;
    }

    public boolean getIsComplex() {
        return this.isComplex;
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates() {
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId())};
    }

    public static void main(String[] stringArray) {
        Parameter.Default default_ = new Parameter.Default(159600, 1.0);
        DataType dataType = new DataType(){

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public int getType() {
                return 0;
            }

            @Override
            public char[] getValidChars() {
                return null;
            }

            @Override
            public int getStateCount() {
                return 400;
            }
        };
        FrequencyModel frequencyModel = new FrequencyModel(dataType, new Parameter.Default(400, 0.0025));
        ComplexSubstitutionModel complexSubstitutionModel = new ComplexSubstitutionModel("test", dataType, frequencyModel, default_);
        long l = System.currentTimeMillis();
        double[] dArray = new double[complexSubstitutionModel.getDataType().getStateCount() * complexSubstitutionModel.getDataType().getStateCount()];
        double d = 1.0;
        complexSubstitutionModel.getTransitionProbabilities(d, dArray);
        long l2 = System.currentTimeMillis();
        System.out.println("Time: " + (l2 - l));
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public void setMaxConditionNumber(double d) {
        this.maxConditionNumber = d;
    }

    public void setCheckConditioning(boolean bl) {
        this.checkConditioning = bl;
    }

    private static DoubleMatrix2D blockDiagonalExponential(double d, DoubleMatrix2D doubleMatrix2D) {
        for (int i = 0; i < doubleMatrix2D.rows(); ++i) {
            if (i + 1 < doubleMatrix2D.rows() && doubleMatrix2D.getQuick(i, i + 1) != 0.0) {
                double d2 = doubleMatrix2D.getQuick(i, i);
                double d3 = doubleMatrix2D.getQuick(i, i + 1);
                double d4 = Math.exp(d * d2);
                double d5 = Math.cos(d * d3);
                double d6 = Math.sin(d * d3);
                doubleMatrix2D.setQuick(i, i, d4 * d5);
                doubleMatrix2D.setQuick(i + 1, i + 1, d4 * d5);
                doubleMatrix2D.setQuick(i, i + 1, d4 * d6);
                doubleMatrix2D.setQuick(i + 1, i, -d4 * d6);
                ++i;
                continue;
            }
            doubleMatrix2D.setQuick(i, i, Math.exp(d * doubleMatrix2D.getQuick(i, i)));
        }
        return doubleMatrix2D;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this)) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean evaluateEarly() {
        return true;
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    public void setNormalization(boolean bl) {
        this.doNormalization = bl;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public boolean isUsed() {
        return super.isUsed() && this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Complex-diagonalizable, irreversible substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.EDWARDS_2011_ANCIENT);
    }

    protected class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return ComplexSubstitutionModel.this.getLogLikelihood();
        }
    }
}

