/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.regular;

import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.modelling.regular.CalendarSpec;
import jdplus.toolkit.base.api.modelling.regular.EasterSpec;
import jdplus.toolkit.base.api.modelling.regular.EstimateSpec;
import jdplus.toolkit.base.api.modelling.regular.OutlierSpec;
import jdplus.toolkit.base.api.modelling.regular.RegressionSpec;
import jdplus.toolkit.base.api.modelling.regular.SeriesSpec;
import jdplus.toolkit.base.api.modelling.regular.TradingDaysSpec;
import jdplus.toolkit.base.api.modelling.regular.TransformSpec;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class ModellingSpec
implements Validatable<ModellingSpec>,
ProcSpecification {
    public static final String METHOD = "demetra.airline";
    public static final String FAMILY = "Modelling";
    public static final String VERSION_V3 = "3.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Modelling", "demetra.airline", "3.0.0");
    public static final ModellingSpec DEFAULT = (ModellingSpec)ModellingSpec.builder().build();
    public static final ModellingSpec DISABLED = (ModellingSpec)ModellingSpec.builder().enabled(false).build();
    @NonNull
    private final SeriesSpec series;
    private final boolean enabled;
    @NonNull
    private final TransformSpec transform;
    @NonNull
    private final EstimateSpec estimate;
    @NonNull
    private final OutlierSpec outliers;
    @NonNull
    private final RegressionSpec regression;
    @NonNull
    private final SarimaSpec arima;
    public static final ModellingSpec FULL;
    private static final String SMETHOD = "Demetra-Airline";

    public static Builder builder() {
        SarimaSpec sarima = SarimaSpec.airline();
        return new Builder().enabled(true).series(SeriesSpec.DEFAULT).transform(TransformSpec.DEFAULT).estimate(EstimateSpec.DEFAULT).outliers(OutlierSpec.DEFAULT_ENABLED).regression(RegressionSpec.DEFAULT).arima(sarima);
    }

    @Override
    public ModellingSpec validate() throws IllegalArgumentException {
        this.outliers.validate();
        this.regression.validate();
        return this;
    }

    @Override
    public AlgorithmDescriptor getAlgorithmDescriptor() {
        return DESCRIPTOR;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    @Override
    public String display() {
        return SMETHOD;
    }

    @Generated
    ModellingSpec(@NonNull SeriesSpec series, boolean enabled, @NonNull TransformSpec transform, @NonNull EstimateSpec estimate, @NonNull OutlierSpec outliers, @NonNull RegressionSpec regression, @NonNull SarimaSpec arima) {
        if (series == null) {
            throw new NullPointerException("series is marked non-null but is null");
        }
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        if (estimate == null) {
            throw new NullPointerException("estimate is marked non-null but is null");
        }
        if (outliers == null) {
            throw new NullPointerException("outliers is marked non-null but is null");
        }
        if (regression == null) {
            throw new NullPointerException("regression is marked non-null but is null");
        }
        if (arima == null) {
            throw new NullPointerException("arima is marked non-null but is null");
        }
        this.series = series;
        this.enabled = enabled;
        this.transform = transform;
        this.estimate = estimate;
        this.outliers = outliers;
        this.regression = regression;
        this.arima = arima;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().series(this.series).enabled(this.enabled).transform(this.transform).estimate(this.estimate).outliers(this.outliers).regression(this.regression).arima(this.arima);
    }

    @NonNull
    @Generated
    public SeriesSpec getSeries() {
        return this.series;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @NonNull
    @Generated
    public TransformSpec getTransform() {
        return this.transform;
    }

    @NonNull
    @Generated
    public EstimateSpec getEstimate() {
        return this.estimate;
    }

    @NonNull
    @Generated
    public OutlierSpec getOutliers() {
        return this.outliers;
    }

    @NonNull
    @Generated
    public RegressionSpec getRegression() {
        return this.regression;
    }

    @NonNull
    @Generated
    public SarimaSpec getArima() {
        return this.arima;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModellingSpec)) {
            return false;
        }
        ModellingSpec other = (ModellingSpec)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        SeriesSpec this$series = this.getSeries();
        SeriesSpec other$series = other.getSeries();
        if (this$series == null ? other$series != null : !((Object)this$series).equals(other$series)) {
            return false;
        }
        TransformSpec this$transform = this.getTransform();
        TransformSpec other$transform = other.getTransform();
        if (this$transform == null ? other$transform != null : !((Object)this$transform).equals(other$transform)) {
            return false;
        }
        EstimateSpec this$estimate = this.getEstimate();
        EstimateSpec other$estimate = other.getEstimate();
        if (this$estimate == null ? other$estimate != null : !((Object)this$estimate).equals(other$estimate)) {
            return false;
        }
        OutlierSpec this$outliers = this.getOutliers();
        OutlierSpec other$outliers = other.getOutliers();
        if (this$outliers == null ? other$outliers != null : !((Object)this$outliers).equals(other$outliers)) {
            return false;
        }
        RegressionSpec this$regression = this.getRegression();
        RegressionSpec other$regression = other.getRegression();
        if (this$regression == null ? other$regression != null : !((Object)this$regression).equals(other$regression)) {
            return false;
        }
        SarimaSpec this$arima = this.getArima();
        SarimaSpec other$arima = other.getArima();
        return !(this$arima == null ? other$arima != null : !((Object)this$arima).equals(other$arima));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        SeriesSpec $series = this.getSeries();
        result = result * 59 + ($series == null ? 43 : ((Object)$series).hashCode());
        TransformSpec $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : ((Object)$transform).hashCode());
        EstimateSpec $estimate = this.getEstimate();
        result = result * 59 + ($estimate == null ? 43 : ((Object)$estimate).hashCode());
        OutlierSpec $outliers = this.getOutliers();
        result = result * 59 + ($outliers == null ? 43 : ((Object)$outliers).hashCode());
        RegressionSpec $regression = this.getRegression();
        result = result * 59 + ($regression == null ? 43 : ((Object)$regression).hashCode());
        SarimaSpec $arima = this.getArima();
        result = result * 59 + ($arima == null ? 43 : ((Object)$arima).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "ModellingSpec(series=" + String.valueOf(this.getSeries()) + ", enabled=" + this.isEnabled() + ", transform=" + String.valueOf(this.getTransform()) + ", estimate=" + String.valueOf(this.getEstimate()) + ", outliers=" + String.valueOf(this.getOutliers()) + ", regression=" + String.valueOf(this.getRegression()) + ", arima=" + String.valueOf(this.getArima()) + ")";
    }

    static {
        TransformSpec tr = TransformSpec.builder().function(TransformationType.Auto).build();
        EasterSpec e = (EasterSpec)EasterSpec.builder().type(EasterSpec.Type.EASTER).test(true).build();
        TradingDaysSpec td = TradingDaysSpec.automatic(LengthOfPeriodType.LeapYear, TradingDaysSpec.AutoMethod.BIC, 0.01, true);
        CalendarSpec cal = (CalendarSpec)CalendarSpec.builder().easter(e).tradingDays(td).build();
        RegressionSpec reg = (RegressionSpec)RegressionSpec.builder().calendar(cal).build();
        OutlierSpec o = (OutlierSpec)OutlierSpec.builder().ao(true).ls(true).build();
        FULL = (ModellingSpec)ModellingSpec.builder().series(SeriesSpec.DEFAULT).enabled(true).transform(tr).estimate(EstimateSpec.DEFAULT).outliers(o).regression(reg).arima(SarimaSpec.airline()).build();
    }

    public static class Builder
    implements Validatable.Builder<ModellingSpec> {
        @Generated
        private SeriesSpec series;
        @Generated
        private boolean enabled;
        @Generated
        private TransformSpec transform;
        @Generated
        private EstimateSpec estimate;
        @Generated
        private OutlierSpec outliers;
        @Generated
        private RegressionSpec regression;
        @Generated
        private SarimaSpec arima;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder series(@NonNull SeriesSpec series) {
            if (series == null) {
                throw new NullPointerException("series is marked non-null but is null");
            }
            this.series = series;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder transform(@NonNull TransformSpec transform) {
            if (transform == null) {
                throw new NullPointerException("transform is marked non-null but is null");
            }
            this.transform = transform;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder estimate(@NonNull EstimateSpec estimate) {
            if (estimate == null) {
                throw new NullPointerException("estimate is marked non-null but is null");
            }
            this.estimate = estimate;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outliers(@NonNull OutlierSpec outliers) {
            if (outliers == null) {
                throw new NullPointerException("outliers is marked non-null but is null");
            }
            this.outliers = outliers;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder regression(@NonNull RegressionSpec regression) {
            if (regression == null) {
                throw new NullPointerException("regression is marked non-null but is null");
            }
            this.regression = regression;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder arima(@NonNull SarimaSpec arima) {
            if (arima == null) {
                throw new NullPointerException("arima is marked non-null but is null");
            }
            this.arima = arima;
            return this;
        }

        @Override
        @Generated
        public @org.jspecify.annotations.NonNull ModellingSpec buildWithoutValidation() {
            return new ModellingSpec(this.series, this.enabled, this.transform, this.estimate, this.outliers, this.regression, this.arima);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "ModellingSpec.Builder(series=" + String.valueOf(this.series) + ", enabled=" + this.enabled + ", transform=" + String.valueOf(this.transform) + ", estimate=" + String.valueOf(this.estimate) + ", outliers=" + String.valueOf(this.outliers) + ", regression=" + String.valueOf(this.regression) + ", arima=" + String.valueOf(this.arima) + ")";
        }
    }
}

