/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.calendars;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Iterator;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Calendar;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.api.timeseries.calendars.HolidaysOption;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.timeseries.calendars.HolidayImpl;
import jdplus.toolkit.base.core.timeseries.calendars.HolidayInfo;
import lombok.Generated;

public final class HolidaysUtility {
    private static final double[] NDAYS = new double[]{31.0, 28.25, 31.0, 30.0, 31.0, 30.0, 31.0, 31.0, 30.0, 31.0, 30.0, 31.0};

    private static boolean match(int[] nonworking, DayOfWeek dow) {
        for (int i = 0; i < nonworking.length; ++i) {
            if (dow.getValue() != nonworking[i]) continue;
            return true;
        }
        return false;
    }

    public static FastMatrix regressionVariables(Holiday[] holidays, TsDomain domain, HolidaysOption option, int[] nonworking, boolean single) {
        TsPeriod P0 = domain.getStartPeriod();
        int nhol = holidays.length;
        FastMatrix M = FastMatrix.make(domain.getLength(), single ? 1 : nhol);
        HolidaysUtility.fill(holidays, P0, option, nonworking, M);
        return M;
    }

    public static boolean fill(Holiday[] holidays, TsPeriod P0, HolidaysOption option, int[] nonworking, FastMatrix M) {
        int nhol = M.getColumnsCount();
        int n = M.getRowsCount();
        LocalDate start = P0.start().toLocalDate();
        LocalDate end = P0.plus((long)n).start().toLocalDate();
        int length = (int)start.until(end, ChronoUnit.DAYS);
        FastMatrix A = FastMatrix.make(length, nhol);
        switch (option) {
            case Previous: {
                HolidaysUtility.fillPreviousWorkingDays(holidays, A, start, nonworking);
                break;
            }
            case Next: {
                HolidaysUtility.fillNextWorkingDays(holidays, A, start, nonworking);
                break;
            }
            case Skip: {
                HolidaysUtility.fillDays(holidays, A, start, nonworking, true);
                break;
            }
            default: {
                HolidaysUtility.fillDays(holidays, A, start, nonworking, false);
            }
        }
        TsPeriod p = P0;
        boolean ok = false;
        for (int i = 0; i < n; ++i) {
            int j0 = (int)start.until(p.start().toLocalDate(), ChronoUnit.DAYS);
            int j1 = (int)start.until(p.end().toLocalDate(), ChronoUnit.DAYS);
            FastMatrix a = A.extract(j0, j1 - j0, 0, nhol);
            DataBlockIterator arows = a.rowsIterator();
            if (nhol == 1) {
                double v = 0.0;
                while (arows.hasNext()) {
                    v += HolidaysUtility.vrow(arows.next());
                }
                if (v > 0.0) {
                    ok = true;
                    M.set(i, 0, v);
                }
            } else {
                DataBlock mrow = M.row(i);
                while (arows.hasNext()) {
                    if (!HolidaysUtility.addrow(arows.next(), mrow)) continue;
                    ok = true;
                }
            }
            p = p.next();
        }
        return ok;
    }

    private static double vrow(DataBlock row) {
        double[] pdata = row.getStorage();
        double x = 0.0;
        for (int j = row.getStartPosition(); j < row.getEndPosition(); j += row.getIncrement()) {
            double s = pdata[j];
            if (!(s > x)) continue;
            x = s;
        }
        return x;
    }

    private static boolean addrow(DataBlock row, DataBlock srow) {
        double[] pdata = row.getStorage();
        double x = 0.0;
        int l = -1;
        int j = row.getStartPosition();
        int k = 0;
        while (j < row.getEndPosition()) {
            double s = pdata[j];
            if (s > x) {
                x = s;
                l = k;
            }
            j += row.getIncrement();
            ++k;
        }
        if (x > 0.0) {
            srow.add(l, x);
            return true;
        }
        return false;
    }

    public static String[] names(Holiday[] hol) {
        String[] n = new String[hol.length];
        for (int i = 0; i < hol.length; ++i) {
            n[i] = hol[i].display();
        }
        return n;
    }

    public static void fillDays(Holiday[] holidays, FastMatrix D, LocalDate start, int[] nonworking, boolean skip) {
        LocalDate end = start.plusDays(D.getRowsCount());
        int col = 0;
        for (Holiday item : holidays) {
            Iterator<HolidayInfo> iter = HolidayInfo.iterable(item, start, end).iterator();
            while (iter.hasNext()) {
                LocalDate date = iter.next().getDay();
                if (skip && HolidaysUtility.match(nonworking, date.getDayOfWeek())) continue;
                long pos = start.until(date, ChronoUnit.DAYS);
                D.set((int)pos, col, item.getWeight());
            }
            if (D.getColumnsCount() <= 1) continue;
            ++col;
        }
    }

    public static void fillPreviousWorkingDays(Holiday[] holidays, FastMatrix D, LocalDate start, int[] nonworking) {
        int n = D.getRowsCount();
        LocalDate end = start.plusDays(n);
        int col = 0;
        for (Holiday item : holidays) {
            Iterator<HolidayInfo> iter = HolidayInfo.iterable(item, start, end).iterator();
            while (iter.hasNext()) {
                LocalDate date = HolidayInfo.getPreviousWorkingDate(iter.next().getDay(), nonworking);
                long pos = start.until(date, ChronoUnit.DAYS);
                if (pos < 0L || pos >= (long)n) continue;
                D.set((int)pos, col, item.getWeight());
            }
            if (D.getColumnsCount() <= 1) continue;
            ++col;
        }
    }

    public static void fillNextWorkingDays(Holiday[] holidays, FastMatrix D, LocalDate start, int[] nonworking) {
        int n = D.getRowsCount();
        LocalDate end = start.plusDays(n);
        int col = 0;
        for (Holiday item : holidays) {
            Iterator<HolidayInfo> iter = HolidayInfo.iterable(item, start, end).iterator();
            while (iter.hasNext()) {
                LocalDate date = HolidayInfo.getNextWorkingDate(iter.next().getDay(), nonworking);
                long pos = start.until(date, ChronoUnit.DAYS);
                if (pos < 0L || pos >= (long)n) continue;
                D.set((int)pos, col, item.getWeight());
            }
            if (D.getColumnsCount() <= 1) continue;
            ++col;
        }
    }

    public static Matrix holidays(Holiday[] holidays, TsDomain domain) {
        int n = domain.getLength();
        double[] h = new double[7 * n];
        LocalDate dstart = domain.start().toLocalDate();
        LocalDate dend = domain.end().toLocalDate();
        HashMap<LocalDate, Double> used = new HashMap<LocalDate, Double>();
        for (int i = 0; i < holidays.length; ++i) {
            Holiday cur = holidays[i];
            LocalDate start = cur.getValidityPeriod().getStart();
            LocalDate end = cur.getValidityPeriod().getEnd();
            if (start.isBefore(dstart)) {
                start = dstart;
            }
            if (end.isAfter(dend)) {
                end = dend;
            }
            if (!start.isBefore(end)) continue;
            for (HolidayInfo info : HolidayInfo.iterable(cur, start, end)) {
                LocalDate curday = info.getDay();
                Double Weight = (Double)used.get(curday);
                double weight = cur.getWeight();
                if (Weight != null && !(weight > Weight)) continue;
                used.put(curday, weight);
                DayOfWeek w = info.getDayOfWeek();
                int pos = domain.indexOf(curday.atStartOfDay());
                if (pos < 0) continue;
                int col = w.getValue() - 1;
                int n2 = n * col + pos;
                h[n2] = h[n2] + (Weight == null ? weight : weight - Weight);
            }
        }
        return Matrix.of((double[])h, (int)n, (int)7);
    }

    public static double[][] longTermMean(Holiday holiday, int freq) {
        HolidayImpl impl = HolidayImpl.implementationOf(holiday);
        return impl == null ? null : impl.getLongTermMeanEffect(freq);
    }

    public static double[][] longTermMean(Holiday[] holidays, int freq) {
        Object rslt = null;
        for (int k = 0; k < holidays.length; ++k) {
            double[][] cur = HolidaysUtility.longTermMean(holidays[k], freq);
            if (cur == null) continue;
            if (rslt == null) {
                rslt = cur;
                continue;
            }
            for (int i = 0; i < cur.length; ++i) {
                if (cur[i] == null) continue;
                if (rslt[i] == null) {
                    rslt[i] = cur[i];
                    continue;
                }
                for (int j = 0; j < 7; ++j) {
                    double[] dArray = rslt[i];
                    int n = j;
                    dArray[n] = dArray[n] + cur[i][j];
                }
            }
        }
        return (double[][])(rslt != null ? rslt : new double[freq][]);
    }

    public static FastMatrix longTermMean(Holiday[] holidays, TsDomain domain) {
        int n = domain.length();
        FastMatrix ltm = FastMatrix.make(n, 7);
        int ifreq = domain.getAnnualFrequency();
        LocalDate start = domain.start().toLocalDate();
        LocalDate end = domain.end().toLocalDate();
        for (int k = 0; k < holidays.length; ++k) {
            double[][] cur;
            Holiday hcur = holidays[k];
            HolidayImpl helper = HolidayImpl.implementationOf(hcur);
            TsDomain xdomain = helper.getDomainForLongTermCorrection(ifreq, start, end).intersection(domain);
            if (xdomain.isEmpty() || (cur = helper.getLongTermMeanEffect(ifreq)) == null) continue;
            int del = domain.getStartPeriod().until(xdomain.getStartPeriod());
            int xstart = xdomain.getStartPeriod().annualPosition();
            for (int p = 0; p < ifreq; ++p) {
                if (cur[p] == null) continue;
                DataBlock mean = DataBlock.of(cur[p]);
                int i = p - xstart;
                if (i < 0) {
                    i += ifreq;
                }
                while (i < xdomain.getLength()) {
                    DataBlock row = ltm.row(i + del);
                    row.add(mean);
                    i += ifreq;
                }
            }
        }
        return ltm;
    }

    public static FastMatrix days(Calendar calendar, int freq, DayOfWeek hol) {
        double[][] mean = HolidaysUtility.longTermMean(calendar.getHolidays(), freq);
        DataBlock[] Mean2 = new DataBlock[freq];
        for (int i = 0; i < freq; ++i) {
            if (mean[i] == null) continue;
            Mean2[i] = DataBlock.of(mean[i]);
            double[] dArray = mean[i];
            int n = hol.getValue() - 1;
            dArray[n] = dArray[n] - Mean2[i].sum();
        }
        int c = 12 / freq;
        FastMatrix M = FastMatrix.make(freq, 7);
        int m = 0;
        for (int i = 0; i < freq; ++i) {
            double avg = 0.0;
            for (int j = 0; j < c; ++j) {
                avg += NDAYS[m];
                ++m;
            }
            DataBlock row = M.row(i);
            row.set(avg / 7.0);
            if (Mean2[i] == null) continue;
            row.sub(Mean2[i]);
        }
        return M;
    }

    public static FastMatrix clustering(FastMatrix days, DayClustering clustering) {
        if (days.getColumnsCount() != 7) {
            throw new IllegalArgumentException();
        }
        FastMatrix M = FastMatrix.make(days.getRowsCount(), clustering.getGroupsCount());
        for (int i = 0; i < 7; ++i) {
            M.column(clustering.groupOf(i)).add(days.column(i));
        }
        return M;
    }

    @Generated
    private HolidaysUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

