# GACE

Generalized Adaptive Capped Estimator  
A stable, deterministic forecasting engine for weekly, monthly, quarterly, and yearly data.

---

## Overview

GACE provides a transparent, tuning-free forecasting method based on hybrid growth signals and adaptive asymmetric caps.  
It extends deterministic capped-growth forecasting to support weekly, monthly, quarterly, and yearly time series with optional seasonal scaling.

The method is designed for:

- demand forecasting  
- operational forecasting  
- financial and portfolio forecasting  
- budgeting and scenario planning  

The philosophy: Stable + Interpretable + Fast  
No nonlinear optimization. No stochastic fitting. Fully deterministic.

---

## Features

- Supports weekly / monthly / quarterly / yearly data  
- Hybrid growth signals (year-over-year, short-term, rolling, drift)  
- Volatility-aware asymmetric caps  
- Seasonal and non-seasonal modes  
- Deterministic, extremely fast computation  
- plot_gace() for visualization  
- Lightweight dependencies  

---

## Installation

Install the released version from CRAN:

```r
install.packages("GACE")
```

---

## Example

```r
library(GACE)

set.seed(1)
y <- ts(rnorm(60, mean = 100, sd = 10), frequency = 12)

fc <- gace_forecast(y, periods = 12, freq = "month")
plot_gace(fc)
```

