/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.BoundAllDiff;
import choco.cp.solver.constraints.global.matching.AllDifferent;
import choco.cp.solver.constraints.global.scheduling.cumulative.Cumulative;
import choco.cp.solver.constraints.integer.DistanceXYC;
import choco.cp.solver.constraints.integer.DistanceXYZ;
import choco.cp.solver.constraints.integer.IntLinComb;
import choco.cp.solver.constraints.integer.bool.BoolIntLinComb;
import choco.cp.solver.constraints.reified.ReifiedIntSConstraint;
import choco.cp.solver.search.BranchingFactory;
import choco.cp.solver.search.integer.branching.AssignVar;
import choco.cp.solver.search.integer.branching.ImpactBasedBranching;
import choco.cp.solver.search.integer.branching.domwdeg.DomOverWDegBranchingNew;
import choco.cp.solver.search.integer.valiterator.IncreasingDomain;
import choco.cp.solver.search.integer.valselector.RandomIntValSelector;
import choco.cp.solver.search.integer.varselector.DomOverDynDeg;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.Comparator;

public class PPSearch {
    protected CPModel mod;
    protected boolean randval = false;
    protected int randvalseed = 0;

    public void setModel(CPModel m) {
        this.mod = m;
    }

    public void setRandomValueHeuristic(int seed) {
        this.randval = true;
        this.randvalseed = seed;
    }

    public boolean isNaryExtensional() {
        return this.mod.getNbConstraintByType(ConstraintType.TABLE) > 0;
    }

    public boolean isSat() {
        return this.mod.getNbConstraintByType(ConstraintType.CLAUSES) > 0;
    }

    public boolean isScheduling() {
        return this.mod.getNbConstraintByType(ConstraintType.DISJUNCTIVE) != 0;
    }

    public boolean isReified() {
        return this.mod.getConstraintByType(ConstraintType.REIFIEDCONSTRAINT).hasNext();
    }

    public boolean isMixedScheduling() {
        return this.mod.getNbConstraintByType(ConstraintType.DISJUNCTIVE) + this.mod.getNbConstraintByType(ConstraintType.PRECEDENCE_DISJOINT) + this.mod.getNbConstraintByType(ConstraintType.LEQ) + this.mod.getNbConstraintByType(ConstraintType.LT) + this.mod.getNbConstraintByType(ConstraintType.GT) + this.mod.getNbConstraintByType(ConstraintType.GEQ) != this.mod.getNbConstraints();
    }

    public boolean setVersatile(CPSolver s, int inittime) {
        int h = this.determineHeuristic(s);
        if (h == 2) {
            return this.setImpact(s, inittime);
        }
        return this.setDomOverWeg(s, inittime);
    }

    public boolean setDomOverDeg(CPSolver s) {
        s.setVarIntSelector(new DomOverDynDeg(s));
        if (this.randval) {
            s.setValIntSelector(new RandomIntValSelector(this.randvalseed));
        } else {
            s.setValIntIterator(new IncreasingDomain());
        }
        return true;
    }

    public boolean setDomOverWeg(CPSolver s, int inittime) {
        if (this.isSat() && s.getNbIntConstraints() == 1) {
            return this.setImpact(s, inittime);
        }
        if (this.randval) {
            if (this.isScheduling()) {
                if (!this.isMixedScheduling()) {
                    AssignVar dwd = BranchingFactory.domWDeg((Solver)s, PPSearch.getBooleanVars(s), new RandomIntValSelector(this.randvalseed));
                    s.attachGoal(dwd);
                    AssignVar dwd2 = BranchingFactory.minDomIncDom(s, PPSearch.getOtherVars(s));
                    s.addGoal(dwd2);
                } else {
                    AssignVar dwd = BranchingFactory.domWDeg((Solver)s, PPSearch.concat(PPSearch.getBooleanVars(s), PPSearch.getOtherVars(s)), new RandomIntValSelector(this.randvalseed));
                    s.attachGoal(dwd);
                }
            } else {
                AssignVar dwd = BranchingFactory.domWDeg((Solver)s, new RandomIntValSelector(this.randvalseed));
                s.attachGoal(dwd);
            }
        } else if (this.isScheduling()) {
            if (!this.isMixedScheduling()) {
                DomOverWDegBranchingNew dwd = BranchingFactory.incDomWDeg(s, PPSearch.getBooleanVars(s), new IncreasingDomain());
                s.attachGoal(dwd);
                AssignVar dwd2 = BranchingFactory.minDomIncDom(s, PPSearch.getOtherVars(s));
                s.addGoal(dwd2);
            } else {
                DomOverWDegBranchingNew dwd = BranchingFactory.incDomWDeg(s, PPSearch.concat(PPSearch.getBooleanVars(s), PPSearch.getOtherVars(s)), new IncreasingDomain());
                s.attachGoal(dwd);
            }
        } else {
            DomOverWDegBranchingNew dwd = BranchingFactory.incDomWDeg(s, new IncreasingDomain());
            s.attachGoal(dwd);
        }
        return true;
    }

    public boolean setImpact(CPSolver s, int initialisationtime) {
        IntDomainVar[] bvs = PPSearch.getBooleanVars(s);
        IntDomainVar[] ovs = PPSearch.getOtherVars(s);
        if (this.isScheduling()) {
            if (!this.isMixedScheduling()) {
                ImpactBasedBranching ibb = new ImpactBasedBranching(s, bvs);
                if (!ibb.getImpactStrategy().initImpacts(initialisationtime)) {
                    return false;
                }
                s.attachGoal(ibb);
                if (this.randval) {
                    ibb.setRandomValueChoice(this.randvalseed);
                }
                AssignVar dwd2 = BranchingFactory.minDomIncDom(s, ovs);
                s.addGoal(dwd2);
            } else {
                ImpactBasedBranching ibb = new ImpactBasedBranching(s, PPSearch.concat(PPSearch.getBooleanVars(s), PPSearch.getOtherVars(s)));
                if (this.randval) {
                    ibb.setRandomValueChoice(this.randvalseed);
                }
                if (!ibb.getImpactStrategy().initImpacts(initialisationtime)) {
                    return false;
                }
                s.attachGoal(ibb);
            }
        } else {
            ImpactBasedBranching ibb = new ImpactBasedBranching(s);
            if (this.randval) {
                ibb.setRandomValueChoice(this.randvalseed);
            }
            if (!ibb.getImpactStrategy().initImpacts(initialisationtime)) {
                return false;
            }
            s.attachGoal(ibb);
        }
        return true;
    }

    public static IntDomainVar[] getBooleanVars(CPSolver s) {
        ArrayList<IntDomainVar> ldvs = new ArrayList<IntDomainVar>(s.getNbIntVars());
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntDomainVar v = s.getIntVar(i);
            if (!v.hasBooleanDomain()) continue;
            ldvs.add(v);
        }
        IntDomainVar[] vs = new IntDomainVar[ldvs.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = (IntDomainVar)ldvs.get(i);
        }
        return vs;
    }

    public static IntDomainVar[] getOtherVars(CPSolver s) {
        ArrayList<IntDomainVar> ldvs = new ArrayList<IntDomainVar>(s.getNbIntVars());
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            IntDomainVar v = s.getIntVar(i);
            if (v.getDomainSize() <= 2) continue;
            ldvs.add(v);
        }
        IntDomainVar[] vs = new IntDomainVar[ldvs.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = (IntDomainVar)ldvs.get(i);
        }
        return vs;
    }

    public static IntDomainVar[] concat(IntDomainVar[] t1, IntDomainVar[] t2) {
        IntDomainVar[] vs = new IntDomainVar[t1.length + t2.length];
        System.arraycopy(t1, 0, vs, 0, t1.length);
        System.arraycopy(t2, 0, vs, t1.length, t2.length);
        return vs;
    }

    public int determineHeuristic(CPSolver s) {
        DisposableIterator<SConstraint> it = s.getConstraintIterator();
        int heuristic = 1;
        if (this.isSat()) {
            return 2;
        }
        if (this.isNaryExtensional()) {
            return 1;
        }
        while (it.hasNext()) {
            int arity;
            SConstraint constraint = (SConstraint)it.next();
            if (constraint instanceof Cumulative) {
                return 2;
            }
            if (constraint instanceof AllDifferent) {
                return 2;
            }
            if (constraint instanceof BoundAllDiff && constraint.getNbVars() > 10) {
                heuristic = 2;
            }
            if (constraint instanceof ReifiedIntSConstraint) {
                return 2;
            }
            if ((constraint instanceof IntLinComb || constraint instanceof BoolIntLinComb) && (arity = constraint.getNbVars()) >= 6) {
                return 2;
            }
            if (constraint instanceof DistanceXYZ) {
                return 1;
            }
            if (!(constraint instanceof DistanceXYC)) continue;
            return 1;
        }
        it.dispose();
        if (PPSearch.getSumOfDomains(s) > 500000) {
            return 1;
        }
        return heuristic;
    }

    public static int getSumOfDomains(CPSolver s) {
        int sum = 0;
        for (int i = 0; i < s.getNbIntVars(); ++i) {
            sum += s.getIntVar(i).getDomainSize();
        }
        return sum;
    }

    public static class BoolSchedComparator
    implements Comparator {
        public int compare(Object o, Object o1) {
            int sd2;
            int sd1 = ((AbstractVar)o).getExtension(2).get();
            if (sd1 > (sd2 = ((AbstractVar)o1).getExtension(2).get())) {
                return -1;
            }
            if (sd1 == sd2) {
                return 0;
            }
            return 1;
        }
    }
}

