## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

knitr::opts_chunk$set(fig.width = 5, fig.height = 5, fig.align = "center")

## ----setup, warning=FALSE, message=FALSE--------------------------------------
library(swaglm)

## -----------------------------------------------------------------------------
n <- 2000
p <- 100

# create design matrix and vector of coefficients
Sigma <- diag(rep(1 / p, p))
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma)
beta <- c(-15, -10, 5, 10, 15, rep(0, p - 5))

## -----------------------------------------------------------------------------
# --------------------- generate from logistic regression with an intercept of one
z <- 1 + X %*% beta
pr <- 1 / (1 + exp(-z))
set.seed(12345)
y <- as.factor(rbinom(n, 1, pr))
y <- as.numeric(y) - 1

## -----------------------------------------------------------------------------
# define swag parameters
quantile_alpha <- .15
p_max <- 20

## -----------------------------------------------------------------------------
swag_obj <- swaglm::swaglm(
  X = X, y = y, p_max = p_max, family = stats::binomial(),
  alpha = quantile_alpha, verbose = TRUE, seed = 123
)
print(swag_obj)

## -----------------------------------------------------------------------------
swag_network <- compute_network(swag_obj)
plot(swag_network, scale_vertex = 0.05)

## -----------------------------------------------------------------------------
B <- 10
res_test <- swaglm_test(swag_obj, B = B)
print(res_test)

## -----------------------------------------------------------------------------
sigma2 <- 4
set.seed(12345)
y <- 1 + X %*% beta + rnorm(n = n, mean = 0, sd = sqrt(sigma2))

## -----------------------------------------------------------------------------
swag_obj <- swaglm::swaglm(
  X = X, y = y, p_max = p_max, family = stats::gaussian(),
  alpha = quantile_alpha, verbose = TRUE, seed = 123
)
print(swag_obj)

## -----------------------------------------------------------------------------
swag_network <- compute_network(swag_obj)
plot(swag_network, scale_vertex = 0.05)

## -----------------------------------------------------------------------------
res_test <- swaglm_test(swag_obj, B = B)
print(res_test)

## -----------------------------------------------------------------------------
eta <- 1 + X %*% beta
lambda <- exp(eta)
set.seed(12345)
y <- rpois(n = n, lambda = lambda)

## -----------------------------------------------------------------------------
# Run swag procedure
swag_obj <- swaglm::swaglm(
  X = X, y = y, p_max = p_max, family = stats::poisson(),
  alpha = quantile_alpha, verbose = TRUE, seed = 123
)
print(swag_obj)

## -----------------------------------------------------------------------------
swag_network <- compute_network(swag_obj)
plot(swag_network, scale_vertex = 0.05)

## -----------------------------------------------------------------------------
res_test <- swaglm_test(swag_obj, B = B)
print(res_test)

