## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----load-and-setup, echo=FALSE, message=FALSE, warning=FALSE-----------------
library(andorR)
data(ethical) 

## ----setup-example------------------------------------------------------------
library(andorR)

# Load the tree from the built-in 'ethical' dataset
dtree <- load_tree_df(ethical)

# Calculate the initial optimisation indices
dtree <- update_tree(dtree)

## ----get-first-influence------------------------------------------------------
# Get the most important next questions
next_questions_df <- get_highest_influence(dtree, top_n = 3)
knitr::kable(next_questions_df)

## ----first-answers------------------------------------------------------------
set_answer(dtree, "GOV5", TRUE, 3)
set_answer(dtree, "ENV4", TRUE, 3)
set_answer(dtree, "SOC1", TRUE, 3)

# Update the tree and view the current state
dtree <- update_tree(dtree)
print_tree(dtree)

## ----final-answers------------------------------------------------------------
# Answer some more questions
set_answer(dtree, "FIN4", TRUE, 3)
set_answer(dtree, "FIN5", TRUE, 3)
set_answer(dtree, "GOV1", TRUE, 3)
set_answer(dtree, "GOV2", TRUE, 3)
set_answer(dtree, "GOV3", TRUE, 3)
set_answer(dtree, "GOV4", TRUE, 3)
set_answer(dtree, "FIN1", TRUE, 3)

# Update and get the final result
dtree <- update_tree(dtree)
print_tree(dtree)

## ----eval=FALSE---------------------------------------------------------------
# # Load the ethical dataset and build the tree
# data(ethical)
# dtree <- load_tree_df(ethical)
# dtree <- update_tree(dtree)
# 
# # Start the interactive analysis loop
# andorR_interactive(dtree)

