/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.cp.solver.constraints.integer.NotMemberBound;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractUnIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class MemberBound
extends AbstractUnIntSConstraint {
    final int lower;
    final int upper;

    public MemberBound(IntDomainVar v0, int lower, int upper) {
        super(v0);
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public void propagate() throws ContradictionException {
        this.v0.updateInf(this.lower, this, false);
        this.v0.updateSup(this.upper, this, false);
        this.setEntailed();
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return new NotMemberBound(this.v0, this.lower, this.upper);
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder("MEMBER(");
        sb.append(this.v0.pretty()).append(",[").append(this.lower).append(",").append(this.upper).append("])");
        return sb.toString();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] >= this.lower && tuple[0] <= this.upper;
    }

    @Override
    public boolean isSatisfied() {
        return this.v0.getInf() >= this.lower && this.v0.getSup() <= this.upper;
    }

    @Override
    public Boolean isEntailed() {
        return this.v0.getInf() >= this.lower && this.v0.getSup() <= this.upper;
    }
}

