## ----fig.width=4, fig.height=4------------------------------------------------
library(calba)
library(ggplot2)
set.seed(42)
side <- 50
n <- 500
trees <- data.frame(
  species = sample(c("oak", "pine", "birch", "maple"), n, replace = TRUE),
  gx = runif(n, 0, side),
  gy = runif(n, 0, side),
  ba = runif(n, 20, 200)
)

ggplot(trees, aes(gx, gy, col = species)) +
  geom_point() +
  coord_fixed() +
  theme_bw()

## -----------------------------------------------------------------------------
nb <- neigh_ba(
  sp = trees$species,
  gx = trees$gx,
  gy = trees$gy,
  ba = trees$ba,
  r = 5,
  mu_values = c(2, 6)
)

head(nb$summary)

## -----------------------------------------------------------------------------
str(nb)

## -----------------------------------------------------------------------------
head(nb$decay)

## -----------------------------------------------------------------------------
nb_bounds <- neigh_ba(
  sp = trees$species,
  gx = trees$gx,
  gy = trees$gy,
  ba = trees$ba,
  r = 5,
  edge_correction = "safe",
  bounds = c(0, 50, 0, 50)
)$summary

head(nb_bounds)

## -----------------------------------------------------------------------------
multi <- neigh_multi_r(
  sp = trees$species,
  gx = trees$gx,
  gy = trees$gy,
  ba = trees$ba,
  r_values = c(3, 5, 10),
  dist_weighted = FALSE
)

multi_r5 <- subset(multi, radius == 5)
head(multi_r5)

## -----------------------------------------------------------------------------
mu_vals <- c(2, 6)

decay_exp <- ba_decay(
  mu_values = mu_vals,
  sp = trees$species,
  gx = trees$gx,
  gy = trees$gy,
  ba = trees$ba,
  r = 5,
  exponential_normal = FALSE
)
head(decay_exp$con_ba_matrix)

decay_expnorm <- ba_decay(
  mu_values = mu_vals,
  sp = trees$species,
  gx = trees$gx,
  gy = trees$gy,
  ba = trees$ba,
  r = 5,
  exponential_normal = TRUE
)
head(decay_expnorm$con_ba_matrix)

## -----------------------------------------------------------------------------
ba_simple_out <- ba_simple(
  sp = trees$species,
  gx = trees$gx,
  gy = trees$gy,
  ba = trees$ba,
  r = 5,
  dist_weighted = TRUE
)

str(ba_simple_out)

## -----------------------------------------------------------------------------
count_total_out <- count_total(trees$gx, trees$gy, r = 5)
head(count_total_out)

