/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.goals.choice;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.BranchingWithLoggingStatements;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.goals.GoalType;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public final class SetVal
implements Goal {
    protected IntDomainVar var;
    protected int val;

    public SetVal(IntDomainVar var, int val) {
        this.var = var;
        this.val = val;
    }

    @Override
    public String pretty() {
        return this.var.pretty() + " <= " + this.val;
    }

    @Override
    public Goal execute(Solver s) throws ContradictionException {
        int ws;
        if (LOGGER.isLoggable(Level.INFO) && (ws = s.getWorldIndex()) <= s.getLoggingMaxDepth()) {
            LOGGER.log(Level.INFO, "{0}{1} {2} {3} {4}", new Object[]{BranchingWithLoggingStatements.makeLoggingMsgPrefix(ws), "down branch ", this.var, "==", this.val});
        }
        this.var.setVal(this.val);
        return null;
    }

    @Override
    public GoalType getType() {
        return GoalType.SET;
    }
}

