/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.TypeOfMatrix;
import lombok.Generated;

public final class LASCL {
    public static void apply(FastMatrix A, TypeOfMatrix type, double cfrom, double cto) {
        if (A.isEmpty()) {
            return;
        }
        double smlnum = 2.220446049250313E-16;
        double bignum = 4.503599627370496E15;
        double cfromc = cfrom;
        double ctoc = cto;
        double cfrom1 = cfromc * smlnum;
        boolean done = false;
        block5: while (!done) {
            double mul;
            if (cfromc == cfrom1) {
                mul = ctoc / cfromc;
                done = true;
                cto1 = ctoc;
            } else {
                cto1 = ctoc / bignum;
                if (cto1 == ctoc) {
                    mul = ctoc;
                    done = true;
                    cfromc = 1.0;
                } else if (Math.abs(cfrom1) > Math.abs(ctoc) && ctoc != 0.0) {
                    mul = smlnum;
                    done = false;
                    cfromc = cfrom1;
                } else if (Math.abs(cto1) > Math.abs(cfromc)) {
                    mul = bignum;
                    done = false;
                    ctoc = cto1;
                } else {
                    mul = ctoc / cfromc;
                    done = true;
                }
            }
            switch (type) {
                case LowerTriangular: {
                    LASCL.lscal(A, mul);
                    continue block5;
                }
                case UpperTriangular: {
                    LASCL.uscal(A, mul);
                    continue block5;
                }
                case UpperHessenberg: {
                    LASCL.hscal(A, mul);
                    continue block5;
                }
            }
            LASCL.gscal(A, mul);
        }
    }

    private static void gscal(FastMatrix A, double mul) {
        double[] storage = A.getStorage();
        int i0 = A.getStartPosition();
        int cinc = A.getColumnIncrement();
        int nr = A.getRowsCount();
        int i1 = i0 + cinc * A.getColumnsCount();
        int j = i0 + 1 + nr;
        int i = i0;
        while (i < i1) {
            int k = i;
            while (k < j) {
                int n = k++;
                storage[n] = storage[n] * mul;
            }
            i += cinc;
            j += cinc;
        }
    }

    private static void lscal(FastMatrix A, double mul) {
        double[] storage = A.getStorage();
        int i0 = A.getStartPosition();
        int nc = A.getColumnsCount();
        int cinc = A.getColumnIncrement();
        int i1 = i0 + cinc * nc;
        int nr = A.getRowsCount();
        int j = i0 + 1 + nr;
        int dinc = cinc + 1;
        int i = i0;
        while (i < i1) {
            int k = i;
            while (k < j) {
                int n = k++;
                storage[n] = storage[n] * mul;
            }
            i += dinc;
            j += cinc;
        }
    }

    private static void uscal(FastMatrix A, double mul) {
        double[] storage = A.getStorage();
        int i0 = A.getStartPosition();
        int cinc = A.getColumnIncrement();
        int nr = A.getRowsCount();
        int i1 = i0 + cinc * A.getColumnsCount();
        int j = i0 + 1;
        int dinc = cinc + 1;
        int i = i0;
        while (i < i1) {
            int k = i;
            while (k < j) {
                int n = k++;
                storage[n] = storage[n] * mul;
            }
            i += cinc;
            j += dinc;
        }
    }

    private static void hscal(FastMatrix A, double mul) {
        double[] storage = A.getStorage();
        int i0 = A.getStartPosition();
        int cinc = A.getColumnIncrement();
        int nr = A.getRowsCount();
        int i1 = i0 + cinc * A.getColumnsCount();
        int j = i0 + 1 + nr;
        int dinc = cinc + 1;
        int i = i0;
        while (i < i1) {
            int k = i;
            while (k < j) {
                int n = k++;
                storage[n] = storage[n] * mul;
            }
            i += dinc;
            j += cinc;
        }
    }

    @Generated
    private LASCL() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

