% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_nc.R
\name{compute_nc_y_ehis_nm}
\alias{compute_nc_y_ehis_nm}
\title{Compute "Edinburgh Handedness Inventory [Youth]: Number missing"}
\usage{
compute_nc_y_ehis_nm(data, name = "nc_y_ehis_nm", combine = TRUE)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{nc_y_ehis_nm}
Edinburgh Handedness Inventory [Youth]: Number missing
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{nc_y_ehis_001}
\item \code{nc_y_ehis_002}
\item \code{nc_y_ehis_003}
\item \code{nc_y_ehis_004}
}
}
}
\examples{
\dontrun{
compute_nc_y_ehis_nm(data) |>
  select(
    data,
    all_of(c("nc_y_ehis_nm", vars_nc_y_ehis))
  )
}
}
\seealso{
\code{\link[=compute_nc_y_ehis_score]{compute_nc_y_ehis_score()}}
}
