% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{ASexplainer}
\alias{ASexplainer}
\title{Create DALEX explainers for multiple ASML-trained models}
\usage{
ASexplainer(training, data, y, labels = NULL, ...)
}
\arguments{
\item{training}{An object of class \code{as_train} containing models trained with \code{AStrain}.}

\item{data}{A \code{data.frame} or \code{matrix} with predictor variables. Must \strong{not} include the target columns.}

\item{y}{A \code{matrix} or \code{data.frame} containing the target variables. Each column corresponds to the output for the model at the same position in \code{training}.}

\item{labels}{Optional character vector of labels for the explainers. If \code{NULL}, \code{names(training)} are used. Must have the same length as \code{training}.}

\item{...}{Additional arguments passed to \code{DALEX::explain}.}
}
\value{
A named list of DALEX explainer objects, one per trained model. Names are taken from \code{labels} or \code{names(training)}.
}
\description{
This function simplifies the use of \CRANpkg{DALEX} with models trained
using \code{AStrain} from \CRANpkg{ASML}. It automatically creates
DALEX explainers for all trained models (one per algorithm in the portfolio),
allowing users to easily apply DALEX functions to analyze model performance,
evaluate feature importance, and generate partial dependence plots (PDPs), among other analyses.
}
\examples{
\dontrun{
library(ASML)
library(DALEX)
data(branching)
features <- branching$x
KPI <- branching$y
lab_rules <- c("max", "sum", "dual", "range", "eig-VI", "eig-CMI")

# Preprocess data
data_obj <- partition_and_normalize(
  features,
  KPI,
  family_column = 1,
  split_by_family = TRUE,
  better_smaller = TRUE
)

# Train models
training <- AStrain(data_obj, method = "rf", parallel = TRUE)

# Create explainers
out <- ASexplainer(
  training,
  data = data_obj$x.test,
  y = data_obj$y.test,
  labels = lab_rules,
  verbose = FALSE
)

# Model performance
mp_regr_rf <- lapply(out, DALEX::model_performance)
do.call(plot, unname(mp_regr_rf))
do.call(plot, c(unname(mp_regr_rf), list(geom = "boxplot")))

# Variable importance
vi_regr_rf <- lapply(out, DALEX::model_parts)
do.call(plot, c(unname(vi_regr_rf), list(max_vars = 5)))

# Partial dependence plots
pdp_regr_rf <- lapply(out, DALEX::model_profile, variable = "degree", type = "partial")
do.call(plot, unname(pdp_regr_rf))
}

}
\references{
Biecek, P. (2018). \emph{DALEX: Explainers for Complex Predictive Models in R}.
Journal of Machine Learning Research, 19(84), 1--5.
\url{http://jmlr.org/papers/v19/18-416.html}
}
