% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{getPed}
\alias{getPed}
\title{Get pedigree}
\usage{
getPed(pop)
}
\arguments{
\item{pop}{a population}
}
\description{
Returns the population's pedigree as stored in the
id, mother and father slots. NULL is returned if the
input population lacks the required.
}
\examples{
# Create a founder population
founderPop = quickHaplo(2,1,2)

# Set simulation parameters
SP = SimParam$new(founderPop)

# Create a population
pop = newPop(founderPop, simParam=SP)

# Get the pedigree
getPed(pop)

# Returns NULL when a population lacks a pedigree
getPed(founderPop)

}
