% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullMarkerGeno}
\alias{pullMarkerGeno}
\title{Pull marker genotypes}
\usage{
pullMarkerGeno(pop, markers, asRaw = FALSE, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{RawPop-class}} or
\code{\link{MapPop-class}}}

\item{markers}{a character vector. Indicates the
names of the loci to be retrieved.}

\item{asRaw}{return in raw (byte) format}

\item{simParam}{an object of \code{\link{SimParam}}, not 
used if pop is \code{\link{MapPop-class}}}
}
\value{
Returns a matrix of genotypes.
}
\description{
Retrieves genotype data for user
specified loci
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)
SP$addSnpChip(5)

#Create population
pop = newPop(founderPop, simParam=SP)

#Pull genotype data for first two markers on chromosome one.
#Marker name is consistent with default naming in AlphaSimR.
pullMarkerGeno(pop, markers=c("1_1","1_2"), simParam=SP)

}
