% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/interval.R
\docType{methods}
\name{interval_hdr}
\alias{interval_hdr}
\alias{interval_hdr-method}
\alias{interval_hdr,MCMC,missing-method}
\title{Bayesian HPD Regions}
\usage{
interval_hdr(x, y, ...)

\S4method{interval_hdr}{MCMC,missing}(x, level = 0.95, calendar = get_calendar(), ...)
}
\arguments{
\item{x}{An \code{\linkS4class{MCMC}} object containing the output of the MCMC algorithm.}

\item{y}{Currently not used.}

\item{...}{Extra arguments to be passed to \code{\link[stats:density]{stats::density()}}.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{calendar}{A \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}).}
}
\value{
Returns a \code{\link{list}} of \code{numeric} \code{\link{matrix}}.
}
\description{
Bayesian HPD Regions
}
\examples{
## Coerce to events
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Rata die
interval_credible(eve, level = 0.95) # Credible interval
interval_hdr(eve, level = 0.68) # HPD interval

## BP
interval_credible(eve, level = 0.95, calendar = BP()) # Credible interval
interval_hdr(eve, level = 0.95, calendar = BP()) # HPD interval
}
\references{
Hyndman, R. J. (1996). Computing and graphing highest density regions.
\emph{American Statistician}, 50: 120-126. \doi{10.2307/2684423}.
}
\seealso{
\code{\link[stats:density]{stats::density()}}, \code{\link[arkhe:interval_hdr]{arkhe::interval_hdr()}}

Other statistics: 
\code{\link{interval_credible}()},
\code{\link{sensitivity}()},
\code{\link{summary}()}
}
\author{
A. Philippe, M.-A. Vibet, T. S. Dye, N. Frerebeau
}
\concept{statistics}
