% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/european_option.R
\name{price_european}
\alias{price_european}
\title{Price European Option with Price Impact}
\usage{
price_european(
  S0,
  K,
  r,
  u,
  d,
  lambda,
  v_u,
  v_d,
  n,
  option_type = "call",
  validate = TRUE
)
}
\arguments{
\item{S0}{Initial stock price (must be positive)}

\item{K}{Strike price (must be positive)}

\item{r}{Gross risk-free rate per period (e.g., 1.05 for 5\% rate)}

\item{u}{Base up factor in CRR model (must be > d)}

\item{d}{Base down factor in CRR model (must be positive)}

\item{lambda}{Price impact coefficient (non-negative)}

\item{v_u}{Hedging volume on up move (non-negative)}

\item{v_d}{Hedging volume on down move (non-negative)}

\item{n}{Number of time steps (positive integer)}

\item{option_type}{Character; either "call" (default) or "put"}

\item{validate}{Logical; if TRUE, performs input validation}
}
\value{
European option price (numeric)
}
\description{
Computes the exact price of a European option (call or put) using the
Cox-Ross-Rubinstein (CRR) binomial model with price impact from
hedging activities.
}
\details{
Computes exact prices for European options (call or put) using the binomial
model with price impact. Price impact from hedging activities modifies the
stock dynamics through adjusted up/down factors and risk-neutral probability.

Unlike path-dependent Asian options, European options only depend on the
terminal stock price, allowing for efficient O(n) computation instead of O(2^n).
See the package vignettes and reference paper for detailed mathematical
formulations.
}
\examples{
# Call option with no price impact
price_european(
  S0 = 100, K = 100, r = 1.05, u = 1.2, d = 0.8,
  lambda = 0, v_u = 0, v_d = 0, n = 10, option_type = "call"
)

# Put option with price impact
price_european(
  S0 = 100, K = 100, r = 1.05, u = 1.2, d = 0.8,
  lambda = 0.1, v_u = 1, v_d = 1, n = 10, option_type = "put"
)

# Verify put-call parity
call <- price_european(100, 100, 1.05, 1.2, 0.8, 0.1, 1, 1, 10, "call")
put <- price_european(100, 100, 1.05, 1.2, 0.8, 0.1, 1, 1, 10, "put")

}
\references{
Tiwari, P., & Majumdar, S. (2025). Asian option valuation under price impact.
\emph{arXiv preprint}. \doi{10.48550/arXiv.2512.07154}
}
\seealso{
\code{\link{price_geometric_asian}}, \code{\link{compute_p_adj}}
}
