% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.lev.R
\name{lm_plot.lev}
\alias{lm_plot.lev}
\title{Plot Standard Residuals vs. Leverage with Cook's Distance Contours}
\usage{
lm_plot.lev(
  mdl,
  ...,
  cook.loess = FALSE,
  parms = lm_plot.parms(mdl),
  df = lm_plot.df(mdl, parms = parms)
)
}
\arguments{
\item{mdl}{A fitted model object (typically from \code{\link[stats]{lm}}).}

\item{...}{Additional arguments (not currently used).}

\item{cook.loess}{Option (logical, default = FALSE) indicates whether to show loess curve for Cook's distances on the plot.}

\item{parms}{List of plotting parameters, usually from \code{lm_plot.parms()}.}

\item{df}{Data frame with augmented model data. Defaults to \code{lm_plot.df(mdl)}.}
}
\value{
A \code{ggplot} object representing the standardized residuals vs leverage plot. Included as an attribute \code{"parms"} is a list containing:
\itemize{
  \item \code{lim} Plotted limits on \code{x} and \code{y} axes,
  \item \code{cook.loess} Option to show loess curve for Cook's distances.
}
}
\description{
Creates a plot of standard residuals versus leverage values, including Cook's distance contours to visualize influential observations.
}
\details{
The plot displays standardized residuals against leverage, overlays Cook's distance contours, and marks outliers based on residuals and Cook's distance. Outlier and influential points can be labeled, and a loess fit line is optionally added.
}
\examples{
mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
lm_plot.lev(mdl)

}
\seealso{
\code{\link{lm_plot.df}}, \code{\link{lm_plot.parms}}
}
