% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_priors.R
\name{tr.power.prior}
\alias{tr.power.prior}
\alias{tr.Power.Prior}
\title{Truncated Power Prior Distribution for Models}
\usage{
tr.power.prior(kappa = 2, trunc)
}
\arguments{
\item{kappa}{parameter in the prior distribution that controls sparsity}

\item{trunc}{parameter that determines truncation in the distribution i.e.
P(gamma; alpha, beta, trunc) = 0 if |gamma| > trunc.}
}
\value{
returns an object of class "prior", with the family and
hyperparameters.
}
\description{
Creates an object representing the prior distribution on models for BAS
using a truncated Distribution on the Model Size where the probability of
gamma proportional to  p^-kappa |gamma| where gamma is the vector of model indicators
and |gamma| is the model size.
}
\details{
The Truncated version
assigns zero probability to all models of size > trunc.
}
\examples{

tr.power.prior(2, 8)
library(MASS)
data(UScrime)
UScrime[, -2] <- log(UScrime[, -2])
crime.bic <- bas.lm(y ~ .,
  data = UScrime, n.models = 2^15, prior = "BIC",
  modelprior = tr.power.prior(2, 8),
  initprobs = "eplogp"
)
}
\seealso{
\code{\link{bas.lm}}, \code{\link{Bernoulli}},\code{\link{uniform}}

Other priors modelpriors: 
\code{\link{Bernoulli}()},
\code{\link{Bernoulli.heredity}()},
\code{\link{beta.binomial}()},
\code{\link{tr.beta.binomial}()},
\code{\link{tr.poisson}()},
\code{\link{uniform}()}
}
\author{
Merlise Clyde
}
\concept{priors modelpriors}
