% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma_posterior.R
\name{bma_posterior}
\alias{bma_posterior}
\title{Compute Posterior Distributions from Graph Search Results}
\usage{
bma_posterior(object, param = "pcor", iter = 5000, progress = TRUE)
}
\arguments{
\item{object}{A ggm_search object}

\item{param}{Compute BMA on either partial correlations "pcor" (default) or on precision matrix "Theta".}

\item{iter}{Number of samples to be drawn, defaults to 5,000}

\item{progress}{Show progress bar, defaults to TRUE}
}
\value{
A list containing posterior samples and the Bayesian Model Averaged 
        parameter estimates.
}
\description{
The `bma_posterior` function samples posterior distributions of graph 
parameters (e.g., partial correlations or precision matrices) based on the 
graph structures sampled during a Bayesian graph search performed by 
\code{\link{ggm_search}}.
}
\details{
This function incorporates uncertainty in both graph structure and parameter 
estimation, providing Bayesian Model Averaged (BMA) parameter estimates. 

Use `bma_posterior` when detailed posterior inference on graph parameters 
is needed, or to refine results obtained from `ggm_search`.
}
\seealso{
\code{\link{ggm_search}}
}
