% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGedcom.R
\name{postProcessGedcom}
\alias{postProcessGedcom}
\title{Post-process GEDCOM Data Frame}
\usage{
postProcessGedcom(
  df_temp,
  remove_empty_cols = TRUE,
  combine_cols = TRUE,
  add_parents = TRUE,
  skinny = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df_temp}{A data frame produced by \code{readGedcom()}.}

\item{remove_empty_cols}{Logical indicating whether to remove columns that are entirely missing.}

\item{combine_cols}{Logical indicating whether to combine columns with duplicate values.}

\item{add_parents}{Logical indicating whether to add parent information.}

\item{skinny}{Logical indicating whether to slim down the data frame.}

\item{verbose}{Logical indicating whether to print progress messages.}
}
\value{
The post-processed data frame.
}
\description{
This function optionally adds parent information, combines duplicate columns,
and removes empty columns from the GEDCOM data frame. It is called by \code{readGedcom()} if \code{post_process = TRUE}.
}
