% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteParamFile.R
\name{WriteParamFile}
\alias{WriteParamFile}
\title{Write a BLM Parameter File}
\usage{
WriteParamFile(ThisProblem, ParamFile, Notes = ThisProblem$Notes)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{ParamFile}{a character value, indicating the file path and name of the
parameter file to write.}

\item{Notes}{A character vector of additional notes to include at the bottom
of the parameter file. The text "written by USERNAME from R: YYYY-MM-DD
HH:MM:SS" will always be written, regardless of the value of this argument.
This will be filled in with a "Notes" item in `ThisProblem`, if available.}
}
\value{
ThisProblem, with the ParamFile element  changed to the ParamFile
  argument.
}
\description{
This function will take a BLM chemical problem list object and
  turn it into a parameter file, effectively doing the opposite of
  `DefineProblem`.
}
\examples{
tf = tempfile()
WriteParamFile(ThisProblem = carbonate_system_problem, ParamFile = tf)
DefineProblem(ParamFile = tf)

}
