% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.DCMB}
\alias{print.DCMB}
\title{Print function for DCMB class of objects}
\usage{
\method{print}{DCMB}(x,digits=3,...)
}
\arguments{
\item{x}{object of class DCMB}

\item{digits}{non-negative integer determining the number of significant digits to print Defaults to 3}

\item{...}{additional arguments to pass to the print function}
}
\value{
prints out the class object details
}
\description{
Prints out the objects of class DCMB
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res1 <- BSTZINB(y, X, A, nchain=2, niter=100, nburn=20, nthin=1)
print(res1)
}

}
