% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootbsw.R
\name{bootbsw}
\alias{bootbsw}
\title{Estimating bootstrap statistics of \code{bsw()}}
\usage{
bootbsw(object, ci_level = 0.95, R = 1000L, maxit = NULL, conswitch = NULL)
}
\arguments{
\item{object}{An object of the class \code{"bsw"}.}

\item{ci_level}{A value between 0 and 1 indicating the confidence interval.
Provides bias-corrected accelerated bootstrap confidence intervals
of the original estimated model parameters of \code{bsw()}.}

\item{R}{A positive integer greater than or equal to 1000 giving the number of bootstrap replicates.}

\item{maxit}{A positive integer giving the maximum number of iterations in the \code{bsw()} algorithm.
If \code{NULL} (the default), the value stored in the \code{bsw} object is passed internally to \code{bootbsw()}.}

\item{conswitch}{Specifies how the constraint matrix is constructed:
\describe{
  \item{1 (default)}{Generates all possible combinations of minimum and maximum values for the predictors (excluding the intercept), resulting in \eqn{2^{m-1}} constraints.
  This formulation constrains model predictions within the observed data range, making it suitable for both risk factor identification and prediction (prognosis).}
  \item{0}{Uses the raw design matrix \code{x} as the constraint matrix, resulting in \eqn{n} constraints.
  This is primarily suitable for identifying risk factors, but not for prediction tasks, as predictions are not bounded to realistic ranges.}
}
If \code{NULL} (the default), the value stored in the \code{bsw} object is passed internally to \code{bootbsw()}.}
}
\value{
An object of class \code{"bsw_boot"}, which is a list containing:
\describe{
  \item{Call_bsw}{The original call to the \code{bsw()} function used to fit the model.}
  \item{Successful_Bootstraps}{The number of bootstrap replicates that were completed successfully.}
  \item{message}{A character string with a status message indicating how many bootstrap samples succeeded.}
  \item{Coefficients}{A matrix with the original estimated model parameters (Orig. Est.), the mean of the bootstrap estimates (Boot. Est.),
the standard error of the bootstrap estimates (Boot. SE), the difference between the bootstrap mean and the original estimate (bias),
the Risk Difference (equal to the estimate; RD), and the bias-corrected accelerated confidence intervals at the specified level.}
  \item{Bootstrap_Object}{An object of class \code{"boot"} (from the \pkg{boot} package) containing the full bootstrap output,
    including replicates and metadata. This can be used for further analyses or plotting.}
}
}
\description{
\code{bootbsw()} applies nonparametric bootstrapping to an object of class \code{"bsw"}
and computes bias-corrected accelerated confidence intervals (BCa) for the estimated Relative Risk.
}
\examples{
\donttest{
set.seed(123)
x <- rnorm(100, 50, 10)
y <- rbinom(100, 1, exp(-4 + x * 0.04))
fit <- bsw(formula = y ~ x, data = data.frame(y = y, x = x))
result <- bootbsw(fit, ci_level = 0.90)
print(result)
}

}
\author{
Julius Johannes Weise, Thomas Wolf, Stefan Wagenpfeil
}
