% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VB_FC_BBM.R
\name{VB_FC_BBM}
\alias{VB_FC_BBM}
\title{VB_FC_BBM}
\usage{
VB_FC_BBM(
  prior_mean,
  prior_var,
  prior_FC,
  method_FC = c("VB1", "VB2"),
  nsamp_u = 10000,
  CI_FC = 0.95,
  return_FC_samp = FALSE,
  prior_params = c(0.001, 0.001),
  BOLD,
  TR = NULL,
  A0,
  S0,
  S0_var,
  maxiter = 100,
  miniter = 3,
  epsilon = 0.001,
  usePar = FALSE,
  PW = FALSE,
  seed = 1234,
  verbose = FALSE
)
}
\arguments{
\item{prior_mean}{(\eqn{V \times Q} matrix) mean maps for each network in the
prior, where \eqn{Q} is the number of networks, and \eqn{V=nvox} is the number
of data locations.}

\item{prior_var}{(\eqn{V \times Q} matrix) between-subject variance maps
for each network in the prior.}

\item{prior_FC}{(list) Parameters of functional connectivity prior.}

\item{method_FC}{Variational Bayes (VB) method for FC Bayesian brain mapping:
\code{"VB1"} (default) uses a conjugate Inverse-Wishart prior for the cor(A);
\code{"VB2"} draws samples from p(cor(A)) to emulate the population distribution
using a combination of Cholesky, SVD, and random pivoting.}

\item{nsamp_u}{For VB1, the number of samples to generate from u ~ Gamma, where
A is Gaussian conditional on u. Default: \code{10000}.}

\item{CI_FC}{Level of posterior credible interval to construct for each FC element.
Default: \code{0.95}.}

\item{return_FC_samp}{Should the FC samples (\eqn{QxQxK}) be returned, where K
is the number of posterior samples generated? May be a large object.  For VB1,
K is equal to nsamp_u. For VB2, K is equal to the number of samples from p(G)
contained in prior_FC.}

\item{prior_params}{Alpha and beta parameters of IG prior on \eqn{\tau^2}
(error variance). Default: \code{0.001} for both.}

\item{BOLD}{(\eqn{V \times T} matrix) preprocessed fMRI data.}

\item{A0, S0, S0_var}{Initial guesses at latent variables: \code{A} (\eqn{TxQ}
mixing matrix), \code{S} (\eqn{QxV} matrix of spatial networks), and
variance matrix \code{S0_var}.}

\item{maxiter}{Maximum number of VB iterations. Default: \code{100}.}

\item{miniter}{Minimum number of VB iterations. Default: \code{3}.}

\item{epsilon}{Smallest proportion change in parameter estimates between iterations.
Default: \code{0.001}.}

\item{usePar}{Parallelize the computation? Default: \code{FALSE}. Can be the
number of cores to use or \code{TRUE}, which will use the number available minus two.}

\item{PW}{Prewhiten to account for residual autocorrelation? Default: \code{FALSE}.}

\item{seed}{(Only applicable if \code{PW}) Seed to use for computing temporal
effective sample size (ESS) to correct sums over \eqn{t}. If \code{NULL},
do not change the seed. Default: \code{1234}.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default: \code{FALSE}.}
}
\value{
A list of computed values, including the final parameter estimates.
}
\description{
VB Algorithm for FC Bayesian brain map
}
\keyword{internal}
