% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_prior.methods.R
\name{plot.prior.cifti}
\alias{plot.prior.cifti}
\title{Plot prior}
\usage{
\method{plot}{prior.cifti}(
  x,
  what = c("maps", "FC"),
  stat = c("mean", "sd", "var"),
  var_method = c("non-negative", "unbiased"),
  FC_method = c("empirical", "IW", "Chol", "none"),
  ...
)
}
\arguments{
\item{x}{The prior from \code{estimate_prior.cifti}}

\item{what}{The \code{"maps"} (default) on the brain, or the \code{"FC"}
matrix. If both are desired, use two separate \code{plot} calls to first
plot the maps and then plot the FC.

If \code{"FC"}, the default color scale will be from blue (-1) to red (1).
This can be changed with the \code{colFUN} argument to
\code{\link[fMRItools]{plot_FC_gg}}.}

\item{stat}{Which prior statistic to plot: the \code{"mean"} (default),
\code{"sd"} for the square root of the variance template, or \code{"var"}
for the variance template.}

\item{var_method}{\code{"non-negative"} (default) or \code{"unbiased"}, for
the variance estimate of the maps. Note that FC variance estimates are
always non-negative.}

\item{FC_method}{If \code{what=="FC"}: empirical (\code{"emp"}) (default),
Inverse-Wishart (\code{"IW"}), or Cholesky (\code{"Chol"}).}

\item{...}{Additional arguments to \code{\link[ciftiTools]{view_xifti}}
if \code{what=="maps"}, or \code{\link[fMRItools]{plot_FC_gg}} if
\code{what=="FC"}.}
}
\value{
The plot
}
\description{
Plot prior
}
