% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_direction.R
\name{p_direction}
\alias{p_direction}
\alias{p_direction.ermod_bin}
\title{Probability of Direction (pd)}
\usage{
\method{p_direction}{ermod_bin}(
  x,
  null = 0,
  as_p = FALSE,
  as_num = FALSE,
  direction = "two-sided",
  ...
)
}
\arguments{
\item{x}{An object of class \code{ermod_bin_*}}

\item{null}{The null hypothesis value. Default is 0.}

\item{as_p}{If \code{TRUE}, the p-direction (pd) values are converted to a
frequentist p-value using \code{\link[bayestestR:pd_to_p]{bayestestR::pd_to_p()}}. Only works when
\code{as_num = TRUE}.}

\item{as_num}{If \code{TRUE}, the output is converted to a numeric value.}

\item{direction}{What type of p-value is requested or provided with
as_p = TRUE. Can be \code{"two-sided"} (default, two tailed) or \code{"one-sided"}
(one tailed).}

\item{...}{Additional arguments passed to \code{\link[bayestestR:p_direction]{bayestestR::p_direction()}}.}
}
\value{
See \code{\link[bayestestR:p_direction]{bayestestR::p_direction()}} for details.
}
\description{
Compute the \strong{Probability of Direction} (\emph{\strong{pd}}). Although differently
expressed, this index is fairly similar (\emph{i.e.}, is strongly correlated) to
the frequentist \strong{p-value}. See \code{\link[bayestestR:p_direction]{bayestestR::p_direction()}} and
\code{vignette("overview_of_vignettes", package = "bayestestR")} >
"Probability of Direction (pd)" page for details.
For converting \strong{pd} to a frequentist \strong{p-value},
see \code{\link[bayestestR:pd_to_p]{bayestestR::pd_to_p()}}.
}
\details{
For the class \verb{ermod_bin_*}, it only calculates the \strong{pd} for
the exposure variable.
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_p_dir()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(bayestestR)

df_er_dr2 <-
  d_sim_binom_cov |>
  dplyr::filter(
    AETYPE == "dr2",
    ID \%in\% seq(1, 500, by = 5)
  ) |>
  dplyr::mutate(AUCss_1000 = AUCss / 1000, BHBA1C_5 = BHBA1C / 5)

ermod_bin <- dev_ermod_bin(
  data = df_er_dr2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5"
)

p_direction(ermod_bin, as_num = TRUE, as_p = TRUE)
}
\dontshow{\}) # examplesIf}
}
