% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Two.Prop.Test.Sample.Size.R
\name{Two.Prop.Test.Sample.Size}
\alias{Two.Prop.Test.Sample.Size}
\title{Sample Size for Comparing Two Proportions}
\usage{
Two.Prop.Test.Sample.Size(p1, p2, alpha, beta, r)
}
\arguments{
\item{p1}{A scalar. The anticipated proportion in Arm 1 (e.g., control).}

\item{p2}{A scalar. The anticipated proportion in Arm 2 (e.g., experimental).}

\item{alpha}{A scalar. The one-sided Type I error rate.}

\item{beta}{A scalar. The Type II error rate (1 - power).}

\item{r}{A scalar. The randomization ratio of Arm 2 to Arm 1 ($n_2/n_1$).}
}
\value{
A numeric vector of length two:
\itemize{
\item The required sample size for Arm 1 ($n_1$).
\item The total required sample size ($n_1 + n_2$).
}
}
\description{
Calculates the required sample size for a two-group comparison of
proportions based on the method of Casagrande, Pike, and Smith (1978).
}
\examples{
Two.Prop.Test.Sample.Size(p1=0.27, p2=0.47, alpha = 0.10, beta=0.2, r=2)

}
\seealso{
\url{https://www2.ccrb.cuhk.edu.hk/stat/proportion/Casagrande.htm}
}
