% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{bi.dist.mixture}
\alias{bi.dist.mixture}
\title{A marginalized finite mixture of component distributions.}
\usage{
bi.dist.mixture(
  mixing_distribution,
  component_distributions,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{mixing_distribution}{A `Categorical` distribution specifying the weights for each mixture component.
The size of this distribution specifies the number of components in the mixture.}

\item{component_distributions}{A list of distributions representing the components of the mixture.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector used to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape of the distribution.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions.}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
When \code{sample=FALSE}: A BI Mixture distribution object (for model building).
        When \code{sample=TRUE}: A JAX array of samples drawn from the Mixture distribution (for direct sampling).
        When \code{create_obj=TRUE}: The raw BI distribution object (for advanced use cases).
}
\description{
This distribution represents a mixture of component distributions, where the
mixing weights are determined by a Categorical distribution. The resulting
distribution can be either a MixtureGeneral (when component distributions
are a list) or a MixtureSameFamily (when component distributions are a single
distribution).
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.mixture(
  mixing_distribution = bi.dist.categorical(probs = c(0.3, 0, 7),create_obj = TRUE),
  component_distributions = c(
  bi.dist.normal(0,1,create_obj = TRUE),
  bi.dist.normal(0,1,create_obj = TRUE),
  bi.dist.normal(0,1,create_obj = TRUE)
  ),
  sample = TRUE
)
}
}
\seealso{
- When \code{sample=FALSE}, a BI marginalized finite mixture distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the marginalized finite mixture distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
