% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importBI.R
\name{importBI}
\alias{importBI}
\title{Import the BI Python Module}
\usage{
importBI(
  platform = "cpu",
  cores = NULL,
  rand_seed = TRUE,
  deallocate = FALSE,
  print_devices_found = TRUE,
  backend = "numpyro"
)
}
\arguments{
\item{platform}{Character string, the computational platform to use
(e.g. `"cpu"` or `"gpu"`). Defaults to `"cpu"`.}

\item{cores}{Integer or `NULL`. Number of CPU cores to use. Defaults to `NULL`.}

\item{rand_seed}{(Boolean): Random seed. Defaults to TRUE.}

\item{deallocate}{Logical. Whether memory should be deallocated when not in use.
Defaults to `FALSE`.}

\item{print_devices_found}{(bool, optional): Whether to print devices found. Defaults to TRUE.}

\item{backend}{(str, optional): Backend to use (numpyro or tfp). Defaults to 'numpyro'.}
}
\value{
An initialized BI module object (Python object via **reticulate**).
}
\description{
This function initializes the BI Python module through **reticulate**,
sets up the environment, and loads the necessary `jax` and `jax.numpy`
modules. The BI module is stored in the hidden object `.bi` for internal use,
but the initialized BI object is also returned for convenience.
}
\details{
- Internally, this function imports the `BI` Python package and assigns it
  to the hidden variable `.bi`.
- It also imports `jax` and `jax.numpy`, assigning them to `jax` and `jnp`
  respectively.
- Startup messages inform the user about the imports.
}
\examples{
\donttest{
library(BayesianInference)
m <- importBI()
}
}
