% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxadbToBeeBDC.R
\name{taxadbToBeeBDC}
\alias{taxadbToBeeBDC}
\title{Import and convert taxadb taxonomies to BeeBDC format}
\usage{
taxadbToBeeBDC(
  name = NULL,
  rank = NULL,
  provider = "gbif",
  version = "22.12",
  collect = TRUE,
  ignore_case = TRUE,
  db = NULL,
  removeEmptyNames = TRUE,
  outPath = getwd(),
  fileName = NULL,
  ...
)
}
\arguments{
\item{name}{Character. Taxonomic scientific name (e.g. "Aves").
As defined by  \code{taxadb::filter_rank()}.}

\item{rank}{Character. Taxonomic rank name. (e.g. "class").
As defined by \code{taxadb::filter_rank()}.}

\item{provider}{Character. From which provider should the hierarchy be returned?
Default is 'gbif', which can also be configured using options(default_taxadb_provide = ...").
See \code{taxadb::td_create()} for a list of recognized providers. NOTE: gbif seems to have the most-complete
columns, especially in terms of scientificNameAuthorship, which is important for matching
ambiguous names.
As defined by \code{taxadb::filter_rank()}.}

\item{version}{Character. Which version of the taxadb provider database should we use? defaults
to latest. See tl_import for details. Default = 22.12.
As defined by \code{taxadb::filter_rank()}.}

\item{collect}{Logical. Should we return an in-memory data.frame
(default, usually the most convenient), or a reference to lazy-eval table on disk
(useful for very large tables on which we may first perform subsequent filtering operations.).
Default = TRUE.
As defined by \code{taxadb::filter_rank()}.}

\item{ignore_case}{Logical. should we ignore case (capitalization) in matching names?
Can be significantly slower to run. Default = TRUE.
As defined by \code{taxadb::filter_rank()}.}

\item{db}{a connection to the taxadb database. See details of \code{taxadb::filter_rank()}. Default
= Null which should work.
As defined by \code{taxadb::filter_rank()}.}

\item{removeEmptyNames}{Logical. If True (default), it will remove entries without an entry
for specificEpithet.}

\item{outPath}{Character. The path to a directory (folder) in which the output should be saved.}

\item{fileName}{Character. The name of the output file, ending in '.csv'.}

\item{...}{Arguments passed to \code{taxadb::td_create()}.}
}
\value{
Returns a taxonomy file (to the R environment and to the disk, if a fileName is
provided) as a tibble that can be used with \code{BeeBDC::harmoniseR()}.
}
\description{
Uses the taxadb R package to download a requested taxonomy and then transforms it into the input
BeeBDC format. This means that any taxonomy in their databases can be used with BeeBDC. You can
also save the output to your computer and to the R environment for immediate use. See
details below for a list of providers or see \code{taxadb::td_create()}.
}
\examples{
\dontrun{

if(require("taxadb")){

  # Run the function using the bee genus Apis as an example...
ApisTaxonomy <- BeeBDC::taxadbToBeeBDC(
  name = "Apis",
  rank = "Genus",
  provider = "gbif",
  version = "22.12",
  removeEmptyNames = TRUE,
  outPath = getwd(),
  fileName = NULL,
  ...
  )
  
  } # END if require
  } # End dontrun

}
\seealso{
\code{\link[=beesTaxonomy]{beesTaxonomy()}} for the bee taxonomy and \code{\link[=harmoniseR]{harmoniseR()}} for the
taxon-cleaning function where these taxonomies are implemented.
}
