% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsvb_formatting.R
\name{BiomassNSVB}
\alias{BiomassNSVB}
\title{BiomassNSVB}
\usage{
BiomassNSVB(
  data,
  input_units = "metric",
  output_units = "metric",
  results = "by_plot"
)
}
\arguments{
\item{data}{A dataframe or tibble with the following columns: division, province, site, plot, stand_org, exp_factor, status, decay_class, species, dbh, ht1, ht2, crown_ratio, top, and cull. Each row must be an observation of an individual tree.}

\item{input_units}{Not a variable (column) in the provided dataframe or tibble. Specifies (1) whether the input dbh, ht1, and ht2 variables were measured using metric (centimeters and meters) or imperial (inches and feet) units; and (2) whether the input expansion factor is in metric (stems per hectare) or imperial (stems per acre) units. Must be set to either "metric" or "imperial". The default is set to "metric".}

\item{output_units}{Not a variable (column) in the provided dataframe or tibble. Specifies whether results will be given in metric (kilograms or megagrams per hectare) or imperial (US tons or US tons per acre) units. Must be set to either "metric" or "imperial". The default is set to "metric".}

\item{results}{Not a variable (column) in the provided dataframe or tibble. Specifies whether the results will be summarized by tree, by plot, by plot as well as species, by plot as well as status (live/dead), or by plot as well as species and status. Must be set to either "by_tree", "by_plot", "by_species", "by_status", or "by_sp_st". The default is set to "by_plot".}
}
\value{
Depends on the results setting:
\itemize{
\item by_tree: a list with two components: (1) total run time for the function and (2) a dataframe with tree-level biomass and carbon estimates (reported in kilograms or US tons).
\item by_plot: a list with two components: (1) total run time for the function and (2) a dataframe with plot-level biomass and carbon estimates (reported in megagrams per hectare or US tons per acre).
\item by_species: a list with two components: (1) total run time for the function and (2) a dataframe with plot-level biomass and carbon estimates, further summarized by species (reported in megagrams per hectare or US tons per acre).
\item by_status: a list with two components: (1) total run time for the function and (2) a dataframe with plot-level biomass and carbon estimates, further summarized by status (live/dead; reported in megagrams per hectare or US tons per acre).
\item by_sp_st: a list with two components: (1) total run time for the function and (2) a dataframe with plot-level biomass and carbon estimates, further summarized by species as well as by status (reported in megagrams per hectare or US tons per acre).
}
}
\description{
Uses the national-scale volume and biomass (NSVB) framework, from GTR-WO-104, to estimate above-ground tree biomass and carbon. The package will summarize to the tree or plot level, with options to additionally summarize by species and/or status.
}
\examples{
BiomassNSVB(data = nsvb_demo,
            input_units = "metric",
            output_units = "metric",
            results = "by_plot")

BiomassNSVB(data = nsvb_demo,
            input_units = "metric",
            output_units = "metric",
            results = "by_status")

}
