% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_bw_firth.R
\name{step_bw_firth}
\alias{step_bw_firth}
\title{Stepwise backward for logistic Firth regression with automated dummy variables conversion (with forced terms)}
\usage{
step_bw_firth(
  reg_model,
  s_lower = "~1",
  s_upper = "all",
  trace = TRUE,
  steps = NULL,
  p_threshold = 0.05,
  data = NULL,
  forced = NULL
)
}
\arguments{
\item{reg_model}{A logistf model object.}

\item{s_lower}{Lower step. Not used; included for compatibility. Default = "~1".}

\item{s_upper}{Upper step. Not used; included for compatibility. Default = "all".}

\item{trace}{Logical. Print each step. Default TRUE.}

\item{steps}{Maximum number of elimination steps. If NULL, set to number of predictors.}

\item{p_threshold}{P-value threshold for elimination. Default = 0.05.}

\item{data}{Data frame. If NULL, extracted from reg_model.}

\item{forced}{Character vector of term names to always keep. Default NULL.}
}
\value{
An object of class "step_bw" with components:
\itemize{
\item final_model: the fitted logistf model
\item steps: a data.frame of each elimination step
}
}
\description{
Extension code to perform stepwise backward on a logistf model with categorical variables.
Automatically transforms predictors that are factors into dummy variables.
}
\examples{
if (requireNamespace("logistf", quietly = TRUE)) {
  library(logistf)
  data <- mtcars
  data$am <- as.factor(data$am)
  regression_model <- logistf(am ~ mpg + cyl + disp, data = data)
  # Perform backward stepwise, forcing 'cyl' to remain
  stepwise <- step_bw_firth(
    regression_model,
    forced = c("cyl"),
    p_threshold = 0.05,
    trace = FALSE
  )
  final_model <- stepwise$final_model
  # Show steps and summary
  stepwise$steps
  summary(final_model)
}

}
\references{
Heinze G, Ploner M, Jiricka L, Steiner G. logistf: Firth’s Bias-Reduced Logistic Regression. 2023.

Efroymson MA. Multiple regression analysis. In: Ralston A, Wilf HS, editors. Mathematical methods for digital computers. New York: Wiley; 1960.

Ullmann T, Heinze G, Hafermann L, Schilhart-Wallisch C, Dunkler D, et al. (2024) Evaluating variable selection methods for multivariable regression models: A simulation study protocol. PLOS ONE 19(8): e0308543
}
