% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgwt_core.R
\name{sgwt_inverse}
\alias{sgwt_inverse}
\title{Inverse SGWT transform (single or batch)}
\usage{
sgwt_inverse(sgwt_decomp, eigenvectors, original_signal = NULL)
}
\arguments{
\item{sgwt_decomp}{SGWT decomposition object from sgwt_forward}

\item{eigenvectors}{Eigenvectors of the graph Laplacian (for inverse GFT)}

\item{original_signal}{Original signal vector OR matrix (n_vertices x n_signals) for error calculation (optional)}
}
\value{
List containing:
  \describe{
    \item{vertex_approximations}{Named list with inverse-transformed signals in vertex domain:}
      \itemize{
        \item{\code{low_pass}: Low-pass (scaling) approximation}
        \item{\code{wavelet_1}, \code{wavelet_2}, etc.: Band-pass (wavelet) approximations by scale}
      }
    \item{reconstructed_signal}{Full reconstructed signal (vector or matrix)}
    \item{reconstruction_error}{RMSE (scalar for single signal, vector for multiple signals)}
  }
}
\description{
Reconstruct signal(s) from filtered Fourier coefficients using inverse GFT.
Handles both single signals and multiple signals efficiently.
Returns detailed inverse transform results including low-pass, band-pass approximations,
reconstructed signal(s), and reconstruction error(s).
}
\examples{
\donttest{
# Create example data and perform forward transform
data <- data.frame(x = runif(50), y = runif(50), signal = rnorm(50))
SG <- initSGWT(data, signals = "signal", J = 3)
SG <- runSpecGraph(SG, k = 10)
eigenvectors <- SG$Graph$eigenvectors
eigenvalues <- SG$Graph$eigenvalues
scales <- SG$Parameters$scales

# Single signal - forward transform first
original_signal <- data$signal
sgwt_decomp <- sgwt_forward(original_signal, eigenvectors, eigenvalues, scales)
inverse_result <- sgwt_inverse(sgwt_decomp, eigenvectors, original_signal)

# Multiple signals (batch processing)
original_signals_matrix <- cbind(data$signal, data$signal * 2)
sgwt_decomp <- sgwt_forward(original_signals_matrix, eigenvectors, eigenvalues, scales)
inverse_result <- sgwt_inverse(sgwt_decomp, eigenvectors, original_signals_matrix)
}
}
