% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{plot_thermal_heatmap}
\alias{plot_thermal_heatmap}
\title{Visualize Thermal Matrix as 2D Heatmap}
\usage{
plot_thermal_heatmap(img_obj, use_processed = TRUE, palette = "inferno")
}
\arguments{
\item{img_obj}{A 'BioThermR' object.}

\item{use_processed}{Logical. If \code{TRUE} (default), plots the 'processed' matrix (showing masking effects).
If \code{FALSE}, plots the original 'raw' data.}

\item{palette}{String. The color map option from the 'viridis' package.
Options include: \code{"magma"}, \code{"inferno"}, \code{"plasma"}, \code{"viridis"}, \code{"cividis"}.
Default is \code{"inferno"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Generates a high-quality raster plot of the thermal data using the 'ggplot2' framework.
             This function allows for quick visualization of raw or processed matrices with
             customizable perceptually uniform color scales (viridis).
}
\details{
The function performs the following steps:
         \itemize{
           \item Converts the thermal matrix into a long-format data frame suitable for ggplot.
           \item Renders the image using \code{geom_raster}.
           \item Maps temperature to color using the specified 'viridis' palette.
           \item Ensures the aspect ratio is preserved (\code{coord_fixed}) so the image does not appear distorted.
           \item Sets \code{NA} values (masked background) to transparent.
         }
         Since the output is a standard ggplot object, layers can be added subsequently (e.g., new titles or annotations).
}
\examples{
\donttest{
# Load raw data
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)

# Apply automated segmentation
img <- roi_segment_ebimage(img, keep_largest = TRUE)

# Standard plot
plot_thermal_heatmap(img)
}
}
