% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{read_thermal_raw}
\alias{read_thermal_raw}
\title{Read a Single .raw Thermal Image File}
\usage{
read_thermal_raw(file_path, width = 160, height = 120, rotate = TRUE)
}
\arguments{
\item{file_path}{String. The full path to the .raw file.}

\item{width}{Integer. The width of the thermal sensor (number of columns). Default is 160.}

\item{height}{Integer. The height of the thermal sensor (number of rows). Default is 120.}

\item{rotate}{Logical. Whether to rotate the image 90 degrees counter-clockwise.
Default is TRUE (corrects orientation for many standard sensor exports).}
}
\value{
A list object of class "BioThermR" containing:
\item{raw}{The original temperature matrix (numeric).}
\item{processed}{A copy of the raw matrix, intended for subsequent ROI filtering or masking.}
\item{meta}{A list containing metadata: \code{filename}, \code{fullpath}, and \code{dims}.}
}
\description{
Reads a binary .raw file (typically 32-bit floating point), converts it into a matrix,
             and constructs a 'BioThermR' object containing raw data and metadata.
}
\examples{
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)
}
