% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.r
\name{roi_filter_interactive}
\alias{roi_filter_interactive}
\title{Interactive ROI Selector with Denoising (Shiny App)}
\usage{
roi_filter_interactive(img_input, start_index = 1, use_processed = TRUE)
}
\arguments{
\item{img_input}{A single 'BioThermR' object OR a list of 'BioThermR' objects (e.g., from \code{read_thermal_batch}).}

\item{start_index}{Integer. The index of the image to start viewing. Default is 1.
Useful for resuming work on a large batch.}

\item{use_processed}{Logical. If \code{TRUE} (default), the interactive filter is applied to the
already 'processed' matrix (e.g., refining an auto-segmented result).
If \code{FALSE}, it starts from the raw data.}
}
\value{
The modified 'BioThermR' object (or list of objects). \strong{Note:} You must assign the result
        of this function to a variable (e.g., \code{data <- roi_filter_interactive(data)}) to save the changes.
}
\description{
Launches a Shiny GUI application that allows users to interactively refine regions of interest (ROI)
             for a batch of thermal images. Key features include dynamic temperature thresholding and
             an automated "Clean Noise" tool that removes artifacts by retaining only the largest connected object (e.g., the mouse).
}
\details{
This function opens a local web server (Shiny App). The workflow is as follows:
         \enumerate{
           \item \strong{Navigate:} Use "Prev/Next" buttons to browse the image batch.
           \item \strong{Threshold:} Adjust the slider to set the min/max temperature range. Real-time feedback is shown on the plot.
           \item \strong{Denoise:} Toggle the "Remove Noise" button. This applies a topological filter (Connected Component Analysis)
                 that identifies the largest contiguous heat source and removes all smaller isolated islands (e.g., urine spots, reflections).
           \item \strong{Confirm:} Click "Confirm" to lock in the settings for the current image and auto-advance.
           \item \strong{Export:} Click "Finish & Export Data" to close the app and return the processed object list to the R console.
         }
}
